/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ChangeModifierFix;
import com.siyeh.ig.psiutils.CloneUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NonPublicCloneInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("non.public.clone.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.public.clone.problem.descriptor", new Object[0]);
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ChangeModifierFix("public");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonPublicCloneVisitor();
    }

    private static class NonPublicCloneVisitor
    extends BaseInspectionVisitor {
        private NonPublicCloneVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            if (method.hasModifierProperty("public") || !CloneUtils.isClone(method)) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!CloneUtils.isCloneable(containingClass)) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

