/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.cloneable;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CloneUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CloneableImplementsCloneInspection
extends BaseInspection {
    public boolean m_ignoreCloneableDueToInheritance = false;

    @NotNull
    public String getID() {
        return "CloneableClassWithoutClone";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cloneable.class.without.clone.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("cloneable.class.without.clone.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("cloneable.class.without.clone.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreCloneableDueToInheritance");
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new CreateCloneMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CloneableImplementsCloneVisitor();
    }

    private class CloneableImplementsCloneVisitor
    extends BaseInspectionVisitor {
        private CloneableImplementsCloneVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiMethod[] methods;
            if (aClass.isInterface() || aClass.isAnnotationType() || aClass.isEnum()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (CloneableImplementsCloneInspection.this.m_ignoreCloneableDueToInheritance ? !CloneUtils.isDirectlyCloneable(aClass) : !CloneUtils.isCloneable(aClass)) {
                return;
            }
            for (PsiMethod method : methods = aClass.getMethods()) {
                if (!CloneUtils.isClone(method)) continue;
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }

    private static class CreateCloneMethodFix
    extends InspectionGadgetsFix {
        private CreateCloneMethodFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("cloneable.class.without.clone.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiClass)) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            String cloneMethod = "public " + element.getText() + " clone() throws java.lang.CloneNotSupportedException {\n" + "return (" + element.getText() + ") super.clone();\n" + "}";
            PsiMethod method = factory.createMethodFromText(cloneMethod, element);
            parent.add((PsiElement)method);
        }
    }
}

