/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class CyclomaticComplexityVisitor
extends JavaRecursiveElementWalkingVisitor {
    private int m_complexity = 1;

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
    }

    public void visitForStatement(@NotNull PsiForStatement statement2) {
        super.visitForStatement(statement2);
        ++this.m_complexity;
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement2) {
        super.visitForeachStatement(statement2);
        ++this.m_complexity;
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement2) {
        super.visitIfStatement(statement2);
        ++this.m_complexity;
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
        super.visitDoWhileStatement(statement2);
        ++this.m_complexity;
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        ++this.m_complexity;
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
        super.visitSwitchStatement(statement2);
        PsiCodeBlock body = statement2.getBody();
        if (body == null) {
            return;
        }
        PsiStatement[] statements = body.getStatements();
        boolean pendingLabel = false;
        for (PsiStatement child : statements) {
            if (child instanceof PsiSwitchLabelStatement) {
                if (!pendingLabel) {
                    ++this.m_complexity;
                }
                pendingLabel = true;
                continue;
            }
            pendingLabel = false;
        }
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
        super.visitWhileStatement(statement2);
        ++this.m_complexity;
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        super.visitPolyadicExpression(expression);
        IElementType token = expression.getOperationTokenType();
        if (token.equals(JavaTokenType.ANDAND) || token.equals(JavaTokenType.OROR)) {
            this.m_complexity += expression.getOperands().length - 1;
        }
    }

    public void visitCatchSection(PsiCatchSection section) {
        super.visitCatchSection(section);
        ++this.m_complexity;
    }

    public int getComplexity() {
        return this.m_complexity;
    }

    public void reset() {
        this.m_complexity = 1;
    }
}

