/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.NotNull;

public class ProtectedMemberInFinalClassInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("protected.member.in.final.class.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("protected.member.in.final.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ProtectedMemberInFinalClassVisitor();
    }

    private static class ProtectedMemberInFinalClassVisitor
    extends BaseInspectionVisitor {
        private ProtectedMemberInFinalClassVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (!method.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            if (MethodUtils.hasSuper(method)) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)method, "protected");
        }

        public void visitField(@NotNull PsiField field) {
            if (!field.hasModifierProperty("protected")) {
                return;
            }
            PsiClass containingClass = field.getContainingClass();
            if (containingClass == null || !containingClass.hasModifierProperty("final")) {
                return;
            }
            this.registerModifierError("protected", (PsiModifierListOwner)field, "protected");
        }
    }
}

