/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.ThrowableResultOfMethodCallIgnoredInspection;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ThrowableInstanceNeverThrownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("throwable.instance.never.thrown.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        String type = TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.RuntimeException", "java.lang.Exception", "java.lang.Error");
        if ("java.lang.RuntimeException".equals(type)) {
            return InspectionGadgetsBundle.message("throwable.instance.never.thrown.runtime.exception.problem.descriptor", new Object[0]);
        }
        if ("java.lang.Exception".equals(type)) {
            return InspectionGadgetsBundle.message("throwable.instance.never.thrown.checked.exception.problem.descriptor", new Object[0]);
        }
        if ("java.lang.Error".equals(type)) {
            return InspectionGadgetsBundle.message("throwable.instance.never.thrown.error.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("throwable.instance.never.thrown.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ExceptionInstanceNeverThrownVisitor();
    }

    private static class ExceptionInstanceNeverThrownVisitor
    extends BaseInspectionVisitor {
        private ExceptionInstanceNeverThrownVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression) {
            super.visitNewExpression(expression);
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "java.lang.Throwable")) {
                return;
            }
            PsiElement parent = ExceptionInstanceNeverThrownVisitor.getParent(expression.getParent());
            if (ExceptionInstanceNeverThrownVisitor.canBeThrown(parent)) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCallExpression.class) != null) {
                return;
            }
            PsiElement typedParent = PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiAssignmentExpression.class, PsiVariable.class});
            PsiElement variable = ThrowableResultOfMethodCallIgnoredInspection.getVariable(typedParent, (PsiElement)expression);
            if (typedParent != null && variable == null) {
                return;
            }
            if (variable instanceof PsiLocalVariable) {
                Query query = ReferencesSearch.search((PsiElement)variable, (SearchScope)variable.getUseScope());
                for (PsiReference reference : query) {
                    PsiElement usage = reference.getElement();
                    PsiElement usageParent = usage.getParent();
                    while (usageParent instanceof PsiParenthesizedExpression) {
                        usageParent = usageParent.getParent();
                    }
                    if (ExceptionInstanceNeverThrownVisitor.canBeThrown(usageParent)) {
                        return;
                    }
                    if (PsiTreeUtil.getParentOfType((PsiElement)usageParent, PsiCallExpression.class) == null) continue;
                    return;
                }
            }
            this.registerError((PsiElement)expression, expression);
        }

        private static boolean canBeThrown(PsiElement parent) {
            return parent instanceof PsiThrowStatement || parent instanceof PsiReturnStatement || parent instanceof PsiLambdaExpression;
        }

        public static PsiElement getParent(PsiElement element) {
            PsiElement parent = element;
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            PsiElement skipped = ExceptionInstanceNeverThrownVisitor.skipInitCause(parent);
            if (skipped != null) {
                return ExceptionInstanceNeverThrownVisitor.getParent(skipped);
            }
            return parent;
        }

        private static PsiElement skipInitCause(PsiElement parent) {
            if (!(parent instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"initCause".equals(methodName)) {
                return null;
            }
            PsiMethod method = methodCallExpression.resolveMethod();
            if (method == null) {
                return null;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return null;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType type = parameters[0].getType();
            if (!type.equalsToText("java.lang.Throwable")) {
                return null;
            }
            return ExceptionInstanceNeverThrownVisitor.getParent(methodCallExpression.getParent());
        }
    }
}

