/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StringConcatenationMissingWhitespaceInspection
extends BaseInspection {
    public boolean ignoreNonStringLiterals = false;

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("string.concatenation.missing.whitespace.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonStringLiterals");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StringConcatenationMissingWhitespaceVisitor();
    }

    private class StringConcatenationMissingWhitespaceVisitor
    extends BaseInspectionVisitor {
        private StringConcatenationMissingWhitespaceVisitor() {
        }

        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            IElementType tokenType = expression.getOperationTokenType();
            if (!JavaTokenType.PLUS.equals(tokenType) || !ExpressionUtils.hasStringType((PsiExpression)expression)) {
                return;
            }
            boolean formatCall = FormatUtils.isFormatCallArgument((PsiElement)expression);
            PsiExpression[] operands = expression.getOperands();
            PsiExpression lhs = operands[0];
            for (int i = 1; i < operands.length; ++i) {
                PsiJavaToken token;
                PsiExpression rhs = operands[i];
                if (this.isMissingWhitespace(lhs, rhs, formatCall) && (token = expression.getTokenBeforeOperand(rhs)) != null) {
                    this.registerError((PsiElement)token, new Object[0]);
                }
                lhs = rhs;
            }
        }

        private boolean isMissingWhitespace(PsiExpression lhs, PsiExpression rhs, boolean formatCall) {
            String rhsLiteral;
            char c;
            String lhsLiteral = ExpressionUtils.getLiteralString(lhs);
            if (lhsLiteral != null) {
                int length = lhsLiteral.length();
                if (length == 0) {
                    return false;
                }
                if (formatCall && lhsLiteral.endsWith("%n")) {
                    return false;
                }
                c = lhsLiteral.charAt(length - 1);
                if (Character.isWhitespace(c) || !Character.isLetterOrDigit(c)) {
                    return false;
                }
            } else if (StringConcatenationMissingWhitespaceInspection.this.ignoreNonStringLiterals) {
                return false;
            }
            if ((rhsLiteral = ExpressionUtils.getLiteralString(rhs)) != null) {
                if (rhsLiteral.isEmpty()) {
                    return false;
                }
                if (formatCall && rhsLiteral.startsWith("%n")) {
                    return false;
                }
                c = rhsLiteral.charAt(0);
                if (Character.isWhitespace(c) || !Character.isLetterOrDigit(c)) {
                    return false;
                }
            } else if (StringConcatenationMissingWhitespaceInspection.this.ignoreNonStringLiterals) {
                return false;
            }
            return true;
        }
    }
}

