/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class StaticFieldReferenceOnSubclassInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "StaticFieldReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("static.field.via.subclass.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        return InspectionGadgetsBundle.message("static.field.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticFieldOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticFieldOnSubclassVisitor();
    }

    private static class StaticFieldOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticFieldOnSubclassVisitor() {
        }

        @Override
        public void visitReferenceExpression(PsiReferenceExpression expression) {
            super.visitReferenceExpression(expression);
            PsiElement qualifier = expression.getQualifier();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            if (!field.hasModifierProperty("static")) {
                return;
            }
            PsiElement qualifierReferent = ((PsiReference)qualifier).resolve();
            if (!(qualifierReferent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)qualifierReferent;
            PsiClass declaringClass = field.getContainingClass();
            if (declaringClass == null) {
                return;
            }
            if (declaringClass.equals(referencedClass)) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)expression.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible((PsiMember)declaringClass, (PsiElement)expression, null)) {
                return;
            }
            PsiElement identifier = expression.getReferenceNameElement();
            if (identifier == null) {
                return;
            }
            this.registerError(identifier, declaringClass, referencedClass);
        }
    }

    private static class StaticFieldOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticFieldOnSubclassFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("static.field.via.subclass.rationalize.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            assert (expression != null);
            PsiField field = (PsiField)expression.resolve();
            assert (field != null);
            PsiReplacementUtil.replaceExpressionWithReferenceTo((PsiExpression)expression, (PsiMember)field);
        }
    }
}

