/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import org.jetbrains.annotations.NotNull;

public class StaticCallOnSubclassInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    @NotNull
    public String getID() {
        return "StaticMethodReferencedViaSubclass";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("static.method.via.subclass.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiClass declaringClass = (PsiClass)infos[0];
        PsiClass referencedClass = (PsiClass)infos[1];
        return InspectionGadgetsBundle.message("static.method.via.subclass.problem.descriptor", declaringClass.getQualifiedName(), referencedClass.getQualifiedName());
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new StaticCallOnSubclassFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new StaticCallOnSubclassVisitor();
    }

    private static class StaticCallOnSubclassVisitor
    extends BaseInspectionVisitor {
        private StaticCallOnSubclassVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            PsiElement qualifier = methodExpression.getQualifier();
            if (!(qualifier instanceof PsiReferenceExpression)) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            if (!method.hasModifierProperty("static")) {
                return;
            }
            PsiElement referent = ((PsiReference)qualifier).resolve();
            if (!(referent instanceof PsiClass)) {
                return;
            }
            PsiClass referencedClass = (PsiClass)referent;
            PsiClass declaringClass = method.getContainingClass();
            if (declaringClass == null) {
                return;
            }
            if (declaringClass.equals(referencedClass)) {
                return;
            }
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)call.getProject()).getResolveHelper();
            if (!resolveHelper.isAccessible((PsiMember)declaringClass, (PsiElement)call, null)) {
                return;
            }
            this.registerMethodCallError(call, declaringClass, referencedClass);
        }
    }

    private static class StaticCallOnSubclassFix
    extends InspectionGadgetsFix {
        private StaticCallOnSubclassFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("static.method.via.subclass.rationalize.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiIdentifier name = (PsiIdentifier)descriptor.getPsiElement();
            PsiReferenceExpression expression = (PsiReferenceExpression)name.getParent();
            if (expression == null) {
                return;
            }
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression.getParent();
            String methodName = expression.getReferenceName();
            if (call == null) {
                return;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            PsiExpressionList argumentList = call.getArgumentList();
            if (containingClass == null) {
                return;
            }
            String containingClassName = containingClass.getQualifiedName();
            String argText = argumentList.getText();
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)call, containingClassName + '.' + call.getTypeArgumentList().getText() + methodName + argText);
        }
    }
}

