/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.EqualityToEqualsFix;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class NumberEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("number.comparison.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("number.comparison.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NumberEqualityVisitor();
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        return new EqualityToEqualsFix();
    }

    private static class NumberEqualityVisitor
    extends BaseInspectionVisitor {
        private NumberEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null || !ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            if (!NumberEqualityVisitor.hasNumberType(lhs) || !NumberEqualityVisitor.hasNumberType(rhs)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), new Object[0]);
        }

        private static boolean hasNumberType(PsiExpression expression) {
            return TypeUtils.expressionHasTypeOrSubtype(expression, "java.lang.Number");
        }
    }
}

