/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

class NonFinalFieldsVisitor
extends BaseInspectionVisitor {
    NonFinalFieldsVisitor() {
    }

    void checkUsedNonFinalFields(PsiMethod method) {
        method.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitClass(PsiClass aClass) {
            }

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                PsiElement element = expression.resolve();
                if (!(element instanceof PsiField)) {
                    return;
                }
                PsiField field = (PsiField)element;
                if (field.hasModifierProperty("final")) {
                    return;
                }
                NonFinalFieldsVisitor.this.registerError((PsiElement)expression, new Object[]{field});
            }
        });
    }
}

