/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameterList;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class MisspelledHashcodeInspectionBase
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("misspelled.hashcode.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("misspelled.hashcode.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MisspelledHashcodeVisitor();
    }

    private static class MisspelledHashcodeVisitor
    extends BaseInspectionVisitor {
        private MisspelledHashcodeVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String methodName = method.getName();
            if (!"hashcode".equals(methodName)) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 0) {
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }
    }
}

