/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.CollectionQueryUpdateCalledVisitor;
import com.siyeh.ig.bugs.ThisPassedAsArgumentVisitor;
import com.siyeh.ig.psiutils.CollectionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MismatchedCollectionQueryUpdateInspectionBase
extends BaseInspection {
    private static final Set<String> QUERY_EXCLUDES = Collections.singleton("java.util.Collections");
    private static final Set<String> UPDATE_EXCLUDES = new HashSet<String>(CollectionUtils.getAllCollectionNames());
    public final ExternalizableStringSet queryNames = new ExternalizableStringSet("compute", "copyInto", "drainTo", "forEach", "parallelStream", "propertyNames", "replaceAll", "save", "store", "stream", "toArray", "write");
    public final ExternalizableStringSet updateNames = new ExternalizableStringSet("add", "clear", "compute", "drainTo", "insert", "load", "merge", "offer", "poll", "push", "put", "remove", "replace", "retain", "set", "take");

    private static boolean isEmptyCollectionInitializer(PsiExpression initializer) {
        PsiExpression[] arguments;
        if (!(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiNewExpression newExpression = (PsiNewExpression)initializer;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return false;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            PsiType argumentType = argument.getType();
            if (argumentType == null) {
                return false;
            }
            if (CollectionUtils.isCollectionClassOrInterface(argumentType)) {
                return false;
            }
            if (!(argumentType instanceof PsiArrayType)) continue;
            return false;
        }
        return true;
    }

    private static boolean collectionQueriedByAssignment(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        CollectionQueriedByAssignmentVisitor visitor = new CollectionQueriedByAssignmentVisitor(variable);
        context.accept((PsiElementVisitor)visitor);
        return visitor.mayBeQueried();
    }

    @NotNull
    public String getID() {
        return "MismatchedQueryAndUpdateOfCollection";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("mismatched.update.collection.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean updated = (Boolean)infos[0];
        if (updated) {
            return InspectionGadgetsBundle.message("mismatched.update.collection.problem.descriptor.updated.not.queried", new Object[0]);
        }
        return InspectionGadgetsBundle.message("mismatched.update.collection.problem.description.queried.not.updated", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedCollectionQueryUpdateVisitor();
    }

    static {
        UPDATE_EXCLUDES.add("java.util.Collections");
    }

    private static class UpdateCallProcessor
    implements Processor<PsiCall> {
        private UpdateCallProcessor() {
        }

        public boolean process(PsiCall call) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null || !UPDATE_EXCLUDES.contains(aClass.getQualifiedName())) {
                return false;
            }
            return !"drainTo".equals(method.getName()) || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.concurrent.BlockingQueue");
        }
    }

    private static class QueryCallProcessor
    implements Processor<PsiCall> {
        private QueryCallProcessor() {
        }

        public boolean process(PsiCall call) {
            PsiMethod method = call.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiClass aClass = method.getContainingClass();
            return aClass != null && QUERY_EXCLUDES.contains(aClass.getQualifiedName());
        }
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends BaseInspectionVisitor {
        private MismatchedCollectionQueryUpdateVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (!this.checkVariable((PsiVariable)field, (PsiElement)containingClass)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated((PsiVariable)field, (PsiElement)containingClass);
            boolean read = this.collectionContentsAreQueried((PsiVariable)field, (PsiElement)containingClass);
            if (read == written) {
                return;
            }
            this.registerFieldError(field, written);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!this.checkVariable((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated((PsiVariable)variable, (PsiElement)codeBlock);
            boolean read = this.collectionContentsAreQueried((PsiVariable)variable, (PsiElement)codeBlock);
            if (read != written) {
                this.registerVariableError((PsiVariable)variable, written);
            }
        }

        private boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type = variable.getType();
            if (!CollectionUtils.isCollectionClassOrInterface(type)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private boolean collectionContentsAreUpdated(PsiVariable variable, PsiElement context) {
            PsiNewExpression newExpression;
            PsiAnonymousClass anonymousClass;
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, new UpdateCallProcessor()) || this.collectionUpdateCalled(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer)) {
                return true;
            }
            if (initializer instanceof PsiNewExpression && (anonymousClass = (newExpression = (PsiNewExpression)initializer).getAnonymousClass()) != null) {
                if (this.collectionUpdateCalled(null, (PsiElement)anonymousClass)) {
                    return true;
                }
                ThisPassedAsArgumentVisitor visitor = new ThisPassedAsArgumentVisitor();
                anonymousClass.accept((PsiElementVisitor)visitor);
                if (visitor.isPassed()) {
                    return true;
                }
            }
            return VariableAccessUtils.variableIsAssigned(variable, context);
        }

        private boolean collectionContentsAreQueried(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.variableIsPassedAsMethodArgument(variable, context, new QueryCallProcessor()) || this.collectionQueryCalled(variable, context)) {
                return true;
            }
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null && !MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(initializer)) {
                return true;
            }
            return MismatchedCollectionQueryUpdateInspectionBase.collectionQueriedByAssignment(variable, context);
        }

        private boolean collectionQueryCalled(PsiVariable variable, PsiElement context) {
            CollectionQueryUpdateCalledVisitor visitor = new CollectionQueryUpdateCalledVisitor(variable, (Set<String>)((Object)MismatchedCollectionQueryUpdateInspectionBase.this.queryNames), true);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isQueriedUpdated();
        }

        private boolean collectionUpdateCalled(@Nullable PsiVariable variable, PsiElement context) {
            CollectionQueryUpdateCalledVisitor visitor = new CollectionQueryUpdateCalledVisitor(variable, (Set<String>)((Object)MismatchedCollectionQueryUpdateInspectionBase.this.updateNames), false);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isQueriedUpdated();
        }
    }

    private static class CollectionQueriedByAssignmentVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean mayBeQueried;
        @NotNull
        private final PsiVariable variable;

        private CollectionQueriedByAssignmentVisitor(@NotNull PsiVariable variable) {
            this.variable = variable;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (this.mayBeQueried) {
                return;
            }
            super.visitElement(element);
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            if (this.mayBeQueried) {
                return;
            }
            super.visitReferenceExpression(expression);
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (!(parent instanceof PsiPolyadicExpression)) {
                return;
            }
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (JavaTokenType.PLUS != tokenType) {
                return;
            }
            PsiElement target = expression.resolve();
            if (!this.variable.equals(target)) {
                return;
            }
            PsiType type = polyadicExpression.getType();
            if (type == null || !type.equalsToText("java.lang.String")) {
                return;
            }
            this.mayBeQueried = true;
        }

        public void visitAssignmentExpression(@NotNull PsiAssignmentExpression assignment) {
            if (this.mayBeQueried) {
                return;
            }
            super.visitAssignmentExpression(assignment);
            PsiExpression lhs = assignment.getLExpression();
            if (!VariableAccessUtils.mayEvaluateToVariable(lhs, this.variable)) {
                return;
            }
            PsiExpression rhs = assignment.getRExpression();
            if (MismatchedCollectionQueryUpdateInspectionBase.isEmptyCollectionInitializer(rhs)) {
                return;
            }
            this.mayBeQueried = true;
        }

        private boolean mayBeQueried() {
            return this.mayBeQueried;
        }
    }
}

