/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.CloneUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

public class MismatchedArrayReadWriteInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "MismatchedReadAndWriteOfArray";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("mismatched.read.write.array.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean written = (Boolean)infos[0];
        if (written) {
            return InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.write.not.read", new Object[0]);
        }
        return InspectionGadgetsBundle.message("mismatched.read.write.array.problem.descriptor.read.not.write", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MismatchedArrayReadWriteVisitor();
    }

    private static class MismatchedArrayReadWriteVisitor
    extends BaseInspectionVisitor {
        private MismatchedArrayReadWriteVisitor() {
        }

        public void visitField(@NotNull PsiField field) {
            boolean read;
            super.visitField(field);
            if (!field.hasModifierProperty("private")) {
                return;
            }
            if (HighlightUtil.isSerializationImplicitlyUsedField(field)) {
                return;
            }
            PsiClass containingClass = PsiUtil.getTopLevelClass((PsiElement)field);
            if (!MismatchedArrayReadWriteVisitor.checkVariable((PsiVariable)field, (PsiElement)containingClass)) {
                return;
            }
            boolean written = MismatchedArrayReadWriteVisitor.arrayContentsAreWritten((PsiVariable)field, (PsiElement)containingClass);
            if (written == (read = MismatchedArrayReadWriteVisitor.arrayContentsAreRead((PsiVariable)field, (PsiElement)containingClass))) {
                return;
            }
            this.registerFieldError(field, written);
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            boolean read;
            super.visitLocalVariable(variable);
            PsiCodeBlock codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class);
            if (!MismatchedArrayReadWriteVisitor.checkVariable((PsiVariable)variable, (PsiElement)codeBlock)) {
                return;
            }
            boolean written = MismatchedArrayReadWriteVisitor.arrayContentsAreWritten((PsiVariable)variable, (PsiElement)codeBlock);
            if (written == (read = MismatchedArrayReadWriteVisitor.arrayContentsAreRead((PsiVariable)variable, (PsiElement)codeBlock))) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, written);
        }

        private static boolean checkVariable(PsiVariable variable, PsiElement context) {
            if (context == null) {
                return false;
            }
            PsiType type = variable.getType();
            if (type.getArrayDimensions() == 0) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssigned(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            if (VariableAccessUtils.variableIsReturned(variable, context)) {
                return false;
            }
            return !VariableAccessUtils.variableIsUsedInArrayInitializer(variable, context);
        }

        private static boolean arrayContentsAreWritten(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.arrayContentsAreAssigned(variable, context)) {
                return true;
            }
            if (!MismatchedArrayReadWriteVisitor.isDefaultArrayInitializer(variable.getInitializer())) {
                return true;
            }
            return MismatchedArrayReadWriteVisitor.variableIsWritten(variable, context);
        }

        private static boolean arrayContentsAreRead(PsiVariable variable, PsiElement context) {
            if (VariableAccessUtils.arrayContentsAreAccessed(variable, context)) {
                return true;
            }
            if (MismatchedArrayReadWriteVisitor.isPossiblyReferenceThatIsReadLater(variable.getInitializer())) {
                return true;
            }
            return MismatchedArrayReadWriteVisitor.variableIsRead(variable, context);
        }

        private static boolean isPossiblyReferenceThatIsReadLater(PsiExpression initializer) {
            if (initializer == null || initializer instanceof PsiNewExpression || initializer instanceof PsiArrayInitializerExpression) {
                return false;
            }
            if (initializer instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)initializer;
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return true;
                }
                if (CloneUtils.isClone(method)) {
                    return false;
                }
                String name = method.getName();
                if (!"copyOf".equals(name) && !"copyOfRange".equals(name)) {
                    return true;
                }
                PsiClass aClass = method.getContainingClass();
                return aClass == null || !"java.util.Arrays".equals(aClass.getQualifiedName());
            }
            return true;
        }

        private static boolean isDefaultArrayInitializer(PsiExpression initializer) {
            if (initializer == null) {
                return true;
            }
            if (initializer instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)initializer;
                PsiArrayInitializerExpression arrayInitializer = newExpression.getArrayInitializer();
                return arrayInitializer == null || MismatchedArrayReadWriteVisitor.isDefaultArrayInitializer((PsiExpression)arrayInitializer);
            }
            if (initializer instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayInitializerExpression = (PsiArrayInitializerExpression)initializer;
                PsiExpression[] initializers = arrayInitializerExpression.getInitializers();
                return initializers.length == 0;
            }
            return false;
        }

        private static boolean variableIsWritten(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            VariableReadWriteVisitor visitor = new VariableReadWriteVisitor(variable, true);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isPassed();
        }

        private static boolean variableIsRead(@NotNull PsiVariable variable, @NotNull PsiElement context) {
            VariableReadWriteVisitor visitor = new VariableReadWriteVisitor(variable, false);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isPassed();
        }

        private static class VariableReadWriteVisitor
        extends JavaRecursiveElementWalkingVisitor {
            @NotNull
            private final PsiVariable variable;
            private final boolean write;
            private boolean passed;

            private VariableReadWriteVisitor(@NotNull PsiVariable variable, boolean write2) {
                this.variable = variable;
                this.write = write2;
            }

            public void visitElement(@NotNull PsiElement element) {
                if (!this.passed) {
                    super.visitElement(element);
                }
            }

            public void visitBinaryExpression(PsiBinaryExpression expression) {
                PsiExpression rhs;
                super.visitBinaryExpression(expression);
                if (this.write || this.passed) {
                    return;
                }
                IElementType tokenType = expression.getOperationTokenType();
                if (!JavaTokenType.EQEQ.equals(tokenType) && !JavaTokenType.NE.equals(tokenType)) {
                    return;
                }
                PsiExpression lhs = expression.getLOperand();
                if (!(lhs instanceof PsiBinaryExpression) && VariableAccessUtils.mayEvaluateToVariable(lhs, this.variable)) {
                    this.passed = true;
                }
                if (!((rhs = expression.getROperand()) instanceof PsiBinaryExpression) && VariableAccessUtils.mayEvaluateToVariable(rhs, this.variable)) {
                    this.passed = true;
                }
            }

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (this.passed) {
                    return;
                }
                super.visitMethodCallExpression(call);
                PsiExpressionList argumentList = call.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                for (int i = 0; i < arguments.length; ++i) {
                    PsiExpression argument = arguments[i];
                    if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
                    if (this.write && i == 0 && VariableReadWriteVisitor.isCallToSystemArraycopy(call)) {
                        return;
                    }
                    if (!this.write && i == 2 && VariableReadWriteVisitor.isCallToSystemArraycopy(call)) {
                        return;
                    }
                    this.passed = true;
                }
            }

            private static boolean isCallToSystemArraycopy(PsiMethodCallExpression call) {
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                String name = methodExpression.getReferenceName();
                if (!"arraycopy".equals(name)) {
                    return false;
                }
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiReferenceExpression)) {
                    return false;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifier;
                PsiElement element = referenceExpression.resolve();
                if (!(element instanceof PsiClass)) {
                    return false;
                }
                return "java.lang.System".equals(((PsiClass)element).getQualifiedName());
            }

            public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
                if (this.passed) {
                    return;
                }
                super.visitNewExpression(newExpression);
                this.visitPsiCall((PsiCall)newExpression);
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                if (this.passed) {
                    return;
                }
                super.visitEnumConstant(enumConstant);
                this.visitPsiCall((PsiCall)enumConstant);
            }

            private void visitPsiCall(PsiCall newExpression) {
                PsiExpression[] arguments;
                PsiExpressionList argumentList = newExpression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                for (PsiExpression argument : arguments = argumentList.getExpressions()) {
                    if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
                    this.passed = true;
                }
            }

            public boolean isPassed() {
                return this.passed;
            }
        }
    }
}

