/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.bugs.FormatDecode;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.FormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MalformedFormatStringInspectionBase
extends BaseInspection {
    @NonNls
    public String additionalClasses = "";
    @NonNls
    public String additionalMethods = "";
    final List<String> classNames = new ArrayList<String>();
    final List<String> methodNames = new ArrayList<String>();

    public MalformedFormatStringInspectionBase() {
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        super.readSettings(node);
        MalformedFormatStringInspectionBase.parseString(this.additionalClasses, this.classNames);
        MalformedFormatStringInspectionBase.parseString(this.additionalMethods, this.methodNames);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        this.additionalClasses = MalformedFormatStringInspectionBase.formatString(this.classNames);
        this.additionalMethods = MalformedFormatStringInspectionBase.formatString(this.methodNames);
        super.writeSettings(node);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("malformed.format.string.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Object value = infos[0];
        if (value instanceof Exception) {
            Exception exception = (Exception)value;
            String message = exception.getMessage();
            if (message != null) {
                return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.illegal", message);
            }
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.malformed", new Object[0]);
        }
        FormatDecode.Validator[] validators = (FormatDecode.Validator[])value;
        int argumentCount = (Integer)infos[1];
        if (validators.length < argumentCount) {
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.many.arguments", argumentCount, validators.length);
        }
        if (validators.length > argumentCount) {
            return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.too.few.arguments", argumentCount, validators.length);
        }
        PsiType argumentType = (PsiType)infos[2];
        FormatDecode.Validator validator = (FormatDecode.Validator)infos[3];
        return InspectionGadgetsBundle.message("malformed.format.string.problem.descriptor.arguments.do.not.match.type", argumentType.getPresentableText(), validator.getSpecifier());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedFormatStringVisitor();
    }

    private class MalformedFormatStringVisitor
    extends BaseInspectionVisitor {
        private MalformedFormatStringVisitor() {
        }

        private int findFirstStringArgumentIndex(PsiExpression[] expressions) {
            int length = expressions.length;
            for (int i = 0; i < length; ++i) {
                PsiExpression expression = expressions[i];
                if (!ExpressionUtils.hasStringType(expression)) continue;
                return i;
            }
            return -1;
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            FormatDecode.Validator[] validators;
            super.visitMethodCallExpression(expression);
            if (!FormatUtils.isFormatCall(expression, MalformedFormatStringInspectionBase.this.methodNames, MalformedFormatStringInspectionBase.this.classNames)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            int formatArgumentIndex = this.findFirstStringArgumentIndex(arguments);
            if (formatArgumentIndex < 0) {
                return;
            }
            PsiExpression formatArgument = arguments[formatArgumentIndex];
            if (!ExpressionUtils.hasStringType(formatArgument) || !PsiUtil.isConstantExpression((PsiExpression)formatArgument)) {
                return;
            }
            PsiType formatType = formatArgument.getType();
            if (formatType == null) {
                return;
            }
            String value = (String)ConstantExpressionUtil.computeCastTo((PsiExpression)formatArgument, (PsiType)formatType);
            if (value == null) {
                return;
            }
            int argumentCount = arguments.length - (formatArgumentIndex + 1);
            try {
                validators = FormatDecode.decode(value, argumentCount);
            }
            catch (FormatDecode.IllegalFormatException e) {
                this.registerError((PsiElement)formatArgument, e);
                return;
            }
            if (validators.length != argumentCount) {
                PsiExpression argument;
                PsiType argumentType;
                if (argumentCount == 1 && (argumentType = (argument = arguments[formatArgumentIndex + 1]).getType()) instanceof PsiArrayType) {
                    return;
                }
                this.registerMethodCallError(expression, validators, argumentCount);
                return;
            }
            for (int i = 0; i < validators.length; ++i) {
                FormatDecode.Validator validator = validators[i];
                PsiExpression argument = arguments[i + formatArgumentIndex + 1];
                PsiType argumentType = argument.getType();
                if (argumentType == null || validator == null || validator.valid(argumentType)) continue;
                this.registerError((PsiElement)argument, validators, argumentCount, argumentType, validator);
                return;
            }
        }
    }
}

