/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ForLoopThatDoesntUseLoopVariableInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        boolean condition = (Boolean)infos[0];
        boolean update = (Boolean)infos[1];
        if (condition && update) {
            return InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.both.condition.and.update", new Object[0]);
        }
        if (condition) {
            return InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.condition", new Object[0]);
        }
        return InspectionGadgetsBundle.message("for.loop.not.use.loop.variable.problem.descriptor.update", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForLoopThatDoesntUseLoopVariableVisitor();
    }

    private static class UseVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private final PsiLocalVariable variable;
        private boolean used;

        private UseVisitor(PsiLocalVariable var) {
            this.variable = var;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (!this.used) {
                super.visitElement(element);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
            if (this.used) {
                return;
            }
            super.visitReferenceExpression(ref);
            PsiElement resolvedElement = ref.resolve();
            if (this.variable.equals(resolvedElement)) {
                this.used = true;
            }
        }

        public boolean isUsed() {
            return this.used;
        }
    }

    private static class ForLoopThatDoesntUseLoopVariableVisitor
    extends BaseInspectionVisitor {
        private ForLoopThatDoesntUseLoopVariableVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            super.visitForStatement(statement2);
            if (ForLoopThatDoesntUseLoopVariableVisitor.conditionUsesInitializer(statement2)) {
                if (!ForLoopThatDoesntUseLoopVariableVisitor.updateUsesInitializer(statement2)) {
                    this.registerStatementError((PsiStatement)statement2, Boolean.FALSE, Boolean.TRUE);
                }
            } else if (ForLoopThatDoesntUseLoopVariableVisitor.updateUsesInitializer(statement2)) {
                this.registerStatementError((PsiStatement)statement2, Boolean.TRUE, Boolean.FALSE);
            } else {
                this.registerStatementError((PsiStatement)statement2, Boolean.TRUE, Boolean.TRUE);
            }
        }

        private static boolean conditionUsesInitializer(PsiForStatement statement2) {
            PsiStatement initialization = statement2.getInitialization();
            PsiExpression condition = statement2.getCondition();
            if (initialization == null) {
                return true;
            }
            if (condition == null) {
                return true;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return true;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return true;
            }
            if (declaredElements[0] == null || !(declaredElements[0] instanceof PsiLocalVariable)) {
                return true;
            }
            PsiLocalVariable localVar = (PsiLocalVariable)declaredElements[0];
            return ForLoopThatDoesntUseLoopVariableVisitor.expressionUsesVariable(condition, localVar);
        }

        private static boolean updateUsesInitializer(PsiForStatement statement2) {
            PsiStatement initialization = statement2.getInitialization();
            PsiStatement update = statement2.getUpdate();
            if (initialization == null) {
                return true;
            }
            if (update == null) {
                return true;
            }
            if (!(initialization instanceof PsiDeclarationStatement)) {
                return true;
            }
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)initialization;
            PsiElement[] declaredElements = declaration.getDeclaredElements();
            if (declaredElements.length != 1) {
                return true;
            }
            if (declaredElements[0] == null || !(declaredElements[0] instanceof PsiLocalVariable)) {
                return true;
            }
            PsiLocalVariable localVar = (PsiLocalVariable)declaredElements[0];
            return ForLoopThatDoesntUseLoopVariableVisitor.statementUsesVariable(update, localVar);
        }

        private static boolean statementUsesVariable(PsiStatement statement2, PsiLocalVariable localVar) {
            UseVisitor useVisitor = new UseVisitor(localVar);
            statement2.accept((PsiElementVisitor)useVisitor);
            return useVisitor.isUsed();
        }

        private static boolean expressionUsesVariable(PsiExpression expression, PsiLocalVariable localVar) {
            UseVisitor useVisitor = new UseVisitor(localVar);
            expression.accept((PsiElementVisitor)useVisitor);
            return useVisitor.isUsed();
        }
    }
}

