/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class EqualsBetweenInconvertibleTypesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("equals.between.inconvertible.types.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiType comparedType = (PsiType)infos[0];
        PsiType comparisonType = (PsiType)infos[1];
        return InspectionGadgetsBundle.message("equals.between.inconvertible.types.problem.descriptor", comparedType.getPresentableText(), comparisonType.getPresentableText());
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EqualsBetweenInconvertibleTypesVisitor();
    }

    private static class EqualsBetweenInconvertibleTypesVisitor
    extends BaseInspectionVisitor {
        private EqualsBetweenInconvertibleTypesVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            PsiType comparisonType;
            PsiExpression expression2;
            PsiExpression expression1;
            boolean staticEqualsCall;
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            if (MethodCallUtils.isEqualsCall(expression)) {
                staticEqualsCall = false;
            } else {
                String name = methodExpression.getReferenceName();
                if (!"equals".equals(name) && !"equal".equals(name)) {
                    return;
                }
                PsiMethod method = expression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String qualifiedName = aClass.getQualifiedName();
                if (!"java.util.Objects".equals(qualifiedName) && !"com.google.common.base.Objects".equals(qualifiedName)) {
                    return;
                }
                staticEqualsCall = true;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (staticEqualsCall) {
                if (arguments.length != 2) {
                    return;
                }
                expression1 = arguments[0];
                expression2 = arguments[1];
            } else {
                if (arguments.length != 1) {
                    return;
                }
                expression1 = arguments[0];
                expression2 = methodExpression.getQualifierExpression();
            }
            if (expression2 == null) {
                PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiClass.class);
                if (aClass == null) {
                    return;
                }
                comparisonType = TypeUtils.getType(aClass);
            } else {
                comparisonType = expression2.getType();
            }
            if (comparisonType == null) {
                return;
            }
            PsiType comparedType = expression1.getType();
            if (comparedType == null) {
                return;
            }
            if (TypeUtils.areConvertible(comparedType, comparisonType)) {
                return;
            }
            this.registerMethodCallError(expression, comparedType, comparisonType);
        }
    }
}

