/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import org.jetbrains.annotations.NotNull;

public class EmptyInitializerInspection
extends BaseInspection {
    @NotNull
    public String getID() {
        return "EmptyClassInitializer";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("empty.class.initializer.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("empty.class.initializer.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new EmptyInitializerFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyInitializerVisitor();
    }

    private static class EmptyInitializerVisitor
    extends BaseInspectionVisitor {
        private EmptyInitializerVisitor() {
        }

        public void visitClassInitializer(@NotNull PsiClassInitializer initializer) {
            super.visitClassInitializer(initializer);
            PsiCodeBlock body = initializer.getBody();
            if (!ControlFlowUtils.isEmptyCodeBlock(body)) {
                return;
            }
            this.registerClassInitializerError(initializer, new Object[0]);
        }
    }

    private static class EmptyInitializerFix
    extends InspectionGadgetsFix {
        private EmptyInitializerFix() {
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("empty.class.initializer.delete.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement codeBlock = element.getParent();
            assert (codeBlock != null);
            PsiElement classInitializer = codeBlock.getParent();
            assert (classInitializer != null);
            EmptyInitializerFix.deleteElement(classInitializer);
        }
    }
}

