/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class CovariantCompareToInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("covariant.compareto.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("covariant.compareto.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CovariantCompareToVisitor();
    }

    private static class CovariantCompareToVisitor
    extends BaseInspectionVisitor {
        private CovariantCompareToVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiSubstitutor superSubstitutor;
            String name = method.getName();
            if (!"compareTo".equals(name)) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.getParametersCount() != 1) {
                return;
            }
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType paramType = parameters[0].getType();
            if (TypeUtils.isJavaLangObject(paramType)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            PsiMethod[] methods = aClass.findMethodsByName("compareTo", false);
            Project project2 = method.getProject();
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
            GlobalSearchScope scope = method.getResolveScope();
            PsiClass comparableClass = psiFacade.findClass("java.lang.Comparable", scope);
            PsiType substitutedTypeParam = null;
            if (comparableClass != null && comparableClass.getTypeParameters().length == 1 && (superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)comparableClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null) {
                substitutedTypeParam = superSubstitutor.substitute(comparableClass.getTypeParameters()[0]);
            }
            for (PsiMethod compareToMethod : methods) {
                if (!CovariantCompareToVisitor.isNonVariantCompareTo(compareToMethod, substitutedTypeParam)) continue;
                return;
            }
            this.registerMethodError(method, new Object[0]);
        }

        private static boolean isNonVariantCompareTo(PsiMethod method, PsiType substitutedTypeParam) {
            PsiClassType objectType = TypeUtils.getObjectType((PsiElement)method);
            if (MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", new PsiType[]{objectType})) {
                return true;
            }
            if (substitutedTypeParam == null) {
                return false;
            }
            return MethodUtils.methodMatches(method, null, (PsiType)PsiType.INT, "compareTo", substitutedTypeParam);
        }
    }
}

