/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparatorMethodParameterNotUsedInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("comparator.method.parameter.not.used.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("comparator.method.parameter.not.used.problem.descriptor", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareMethodDoesNotUseParameterVisitor();
    }

    private static class CompareMethodDoesNotUseParameterVisitor
    extends BaseInspectionVisitor {
        private CompareMethodDoesNotUseParameterVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!MethodUtils.methodMatches(method, "java.util.Comparator", (PsiType)PsiType.INT, "compare", new PsiType[]{PsiType.NULL, PsiType.NULL})) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            ParameterAccessVisitor visitor = new ParameterAccessVisitor(parameters);
            body.accept((PsiElementVisitor)visitor);
            Collection unusedParameters = visitor.getUnusedParameters();
            for (PsiParameter unusedParameter : unusedParameters) {
                this.registerVariableError((PsiVariable)unusedParameter, new Object[0]);
            }
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementWalkingVisitor {
            private final Set<PsiParameter> parameters;

            private ParameterAccessVisitor(@NotNull PsiParameter[] parameters) {
                this.parameters = new HashSet<PsiParameter>(Arrays.asList(parameters));
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (this.parameters.isEmpty()) {
                    return;
                }
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter = (PsiParameter)target;
                this.parameters.remove(parameter);
            }

            private Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }
        }
    }
}

