/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClassNewInstanceInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("class.new.instance.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("class.new.instance.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ClassNewInstanceFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ClassNewInstanceVisitor();
    }

    private static class ClassNewInstanceVisitor
    extends BaseInspectionVisitor {
        private ClassNewInstanceVisitor() {
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"newInstance".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiType qualifierType = qualifier.getType();
            if (!(qualifierType instanceof PsiClassType)) {
                return;
            }
            PsiClassType classType = (PsiClassType)qualifierType;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            String className = aClass.getQualifiedName();
            if (!"java.lang.Class".equals(className)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }

    private static class ClassNewInstanceFix
    extends InspectionGadgetsFix {
        private ClassNewInstanceFix() {
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("class.new.instance.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) {
            PsiMethod method;
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression methodExpression = (PsiReferenceExpression)parent;
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return;
            }
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiMethodCallExpression)) {
                return;
            }
            PsiElement parentOfType = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiTryStatement.class, PsiLambdaExpression.class});
            if (parentOfType instanceof PsiTryStatement) {
                PsiTryStatement tryStatement = (PsiTryStatement)parentOfType;
                ClassNewInstanceFix.addCatchBlock(tryStatement, "java.lang.NoSuchMethodException", "java.lang.reflect.InvocationTargetException");
            } else if (parentOfType instanceof PsiLambdaExpression) {
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiElement)parentOfType);
                if (FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{method})) {
                    ClassNewInstanceFix.addThrowsClause(method, "java.lang.NoSuchMethodException", "java.lang.reflect.InvocationTargetException");
                }
            } else {
                method = (PsiMethod)parentOfType;
                ClassNewInstanceFix.addThrowsClause(method, "java.lang.NoSuchMethodException", "java.lang.reflect.InvocationTargetException");
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)grandParent;
            String newExpression = qualifier.getText() + ".getConstructor().newInstance()";
            PsiReplacementUtil.replaceExpression((PsiExpression)methodCallExpression, newExpression);
        }

        private static void addThrowsClause(PsiMethod method, String ... exceptionNames) {
            PsiReferenceList throwsList = method.getThrowsList();
            PsiClassType[] referencedTypes = throwsList.getReferencedTypes();
            HashSet<String> presentExceptionNames = new HashSet<String>();
            for (PsiClassType referencedType : referencedTypes) {
                String exceptionName = referencedType.getCanonicalText();
                presentExceptionNames.add(exceptionName);
            }
            Project project2 = method.getProject();
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            GlobalSearchScope scope = method.getResolveScope();
            for (String exceptionName : exceptionNames) {
                if (presentExceptionNames.contains(exceptionName)) continue;
                PsiJavaCodeReferenceElement throwsReference = factory.createReferenceElementByFQClassName(exceptionName, scope);
                PsiElement element = throwsList.add((PsiElement)throwsReference);
                codeStyleManager.shortenClassReferences(element);
            }
        }

        protected static void addCatchBlock(PsiTryStatement tryStatement, String ... exceptionNames) throws IncorrectOperationException {
            Project project2 = tryStatement.getProject();
            PsiParameter[] parameters = tryStatement.getCatchBlockParameters();
            HashSet<String> presentExceptionNames = new HashSet<String>();
            for (PsiParameter parameter : parameters) {
                PsiType type = parameter.getType();
                String exceptionName = type.getCanonicalText();
                presentExceptionNames.add(exceptionName);
            }
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            String name = codeStyleManager.suggestUniqueVariableName("e", (PsiElement)tryStatement.getTryBlock(), false);
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            for (String exceptionName : exceptionNames) {
                if (presentExceptionNames.contains(exceptionName)) continue;
                PsiClassType type = (PsiClassType)factory.createTypeFromText(exceptionName, (PsiElement)tryStatement);
                PsiCatchSection section = factory.createCatchSection((PsiType)type, name, (PsiElement)tryStatement);
                PsiCatchSection element = (PsiCatchSection)tryStatement.add((PsiElement)section);
                codeStyleManager.shortenClassReferences((PsiElement)element);
            }
        }
    }
}

