/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import org.jetbrains.annotations.NotNull;

public class CastConflictsWithInstanceofInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiReferenceExpression referenceExpression = (PsiReferenceExpression)infos[0];
        return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.problem.descriptor", referenceExpression.getText());
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        String castExpressionType = ((PsiTypeElement)infos[1]).getText();
        String instanceofType = ((PsiTypeElement)infos[2]).getText();
        return new InspectionGadgetsFix[]{new ReplaceCastFix(instanceofType, castExpressionType), new ReplaceInstanceofFix(instanceofType, castExpressionType)};
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CastConflictsWithInstanceofVisitor();
    }

    private static class ReplaceInstanceofFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        public ReplaceInstanceofFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @NotNull
        public String getFamilyName() {
            return "Replace instanceOf type";
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix2", this.myInstanceofType, this.myCastType);
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return instanceofTypeElement.replace((PsiElement)castTypeElement);
        }
    }

    private static class ReplaceCastFix
    extends ReplaceFix {
        private final String myInstanceofType;
        private final String myCastType;

        public ReplaceCastFix(String instanceofType, String castType) {
            this.myInstanceofType = instanceofType;
            this.myCastType = castType;
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("cast.conflicts.with.instanceof.quickfix1", this.myCastType, this.myInstanceofType);
        }

        @NotNull
        public String getFamilyName() {
            return "Replace cast type";
        }

        @Override
        protected PsiElement replace(PsiTypeElement castTypeElement, PsiTypeElement instanceofTypeElement) {
            return castTypeElement.replace((PsiElement)instanceofTypeElement);
        }
    }

    private static abstract class ReplaceFix
    extends InspectionGadgetsFix {
        protected ReplaceFix() {
        }

        @Override
        protected final void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiReferenceExpression reference;
            PsiTypeElement castTypeElement;
            PsiElement element = descriptor.getPsiElement();
            if (element instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)element;
                castTypeElement = typeCastExpression.getCastType();
                PsiExpression operand = typeCastExpression.getOperand();
                if (!(operand instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)operand;
            } else if (element instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                PsiExpression qualifier = methodExpression.getQualifierExpression();
                if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                    return;
                }
                PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
                castTypeElement = classObjectAccessExpression.getOperand();
                PsiExpressionList argumentList = methodCallExpression.getArgumentList();
                PsiExpression[] arguments = argumentList.getExpressions();
                if (arguments.length != 1) {
                    return;
                }
                PsiExpression argument = arguments[0];
                if (!(argument instanceof PsiReferenceExpression)) {
                    return;
                }
                reference = (PsiReferenceExpression)argument;
            } else {
                return;
            }
            if (castTypeElement == null) {
                return;
            }
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castTypeElement.getType(), reference, element);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            PsiElement newElement = this.replace(castTypeElement, instanceofTypeElement);
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project2);
            codeStyleManager.shortenClassReferences(newElement);
        }

        protected abstract PsiElement replace(PsiTypeElement var1, PsiTypeElement var2);
    }

    private static class CastConflictsWithInstanceofVisitor
    extends BaseInspectionVisitor {
        private CastConflictsWithInstanceofVisitor() {
        }

        public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            PsiTypeElement castType = expression.getCastType();
            if (castType == null) {
                return;
            }
            PsiType type = castType.getType();
            PsiExpression operand = ParenthesesUtils.stripParentheses(expression.getOperand());
            if (!(operand instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)operand;
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(type, referenceExpression, (PsiElement)expression);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            if (instanceofTypeElement == null) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression, castType, instanceofTypeElement);
        }

        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"cast".equals(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String qualifiedName = containingClass.getQualifiedName();
            if (!"java.lang.Class".equals(qualifiedName)) {
                return;
            }
            PsiExpression qualifier = ParenthesesUtils.stripParentheses(methodExpression.getQualifierExpression());
            if (!(qualifier instanceof PsiClassObjectAccessExpression)) {
                return;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)qualifier;
            PsiTypeElement operand = classObjectAccessExpression.getOperand();
            PsiType castType = operand.getType();
            if (!(castType instanceof PsiClassType)) {
                return;
            }
            PsiExpressionList argumentList = expression.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = ParenthesesUtils.stripParentheses(arguments[0]);
            if (!(argument instanceof PsiReferenceExpression)) {
                return;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)argument;
            PsiInstanceOfExpression conflictingInstanceof = InstanceOfUtils.getConflictingInstanceof(castType, referenceExpression, (PsiElement)expression);
            if (conflictingInstanceof == null) {
                return;
            }
            PsiTypeElement instanceofTypeElement = conflictingInstanceof.getCheckType();
            this.registerError((PsiElement)expression, referenceExpression, operand, instanceofTypeElement);
        }
    }
}

