/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ArrayEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("array.comparison.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("array.comparison.problem.descriptor", new Object[0]);
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiArrayType type = (PsiArrayType)infos[0];
        PsiType componentType = type.getComponentType();
        if (componentType instanceof PsiArrayType) {
            return new ArrayEqualityFix(true);
        }
        return new ArrayEqualityFix(false);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayEqualityVisitor();
    }

    private static class ArrayEqualityVisitor
    extends BaseInspectionVisitor {
        private ArrayEqualityVisitor() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            PsiExpression rhs = expression.getROperand();
            if (rhs == null || !ComparisonUtils.isEqualityComparison((PsiExpression)expression)) {
                return;
            }
            PsiExpression lhs = expression.getLOperand();
            PsiType lhsType = lhs.getType();
            if (!(lhsType instanceof PsiArrayType) || !(rhs.getType() instanceof PsiArrayType)) {
                return;
            }
            this.registerError((PsiElement)expression.getOperationSign(), lhsType);
        }
    }

    private static class ArrayEqualityFix
    extends InspectionGadgetsFix {
        private final boolean deepEquals;

        public ArrayEqualityFix(boolean deepEquals) {
            this.deepEquals = deepEquals;
        }

        @NotNull
        public String getName() {
            if (this.deepEquals) {
                return InspectionGadgetsBundle.message("replace.with.arrays.deep.equals", new Object[0]);
            }
            return InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("replace.with.arrays.equals", new Object[0]);
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            IElementType tokenType = binaryExpression.getOperationTokenType();
            StringBuilder newExpressionText = new StringBuilder();
            if (JavaTokenType.NE.equals(tokenType)) {
                newExpressionText.append('!');
            } else if (!JavaTokenType.EQEQ.equals(tokenType)) {
                return;
            }
            if (this.deepEquals) {
                newExpressionText.append("java.util.Arrays.deepEquals(");
            } else {
                newExpressionText.append("java.util.Arrays.equals(");
            }
            newExpressionText.append(binaryExpression.getLOperand().getText());
            newExpressionText.append(',');
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            newExpressionText.append(rhs.getText());
            newExpressionText.append(')');
            PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)binaryExpression, newExpressionText.toString());
        }
    }
}

