/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bitwise;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

public class ShiftOutOfRangeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer value = (Integer)infos[0];
        if (value > 0) {
            return InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.too.large", new Object[0]);
        }
        return InspectionGadgetsBundle.message("shift.operation.by.inappropriate.constant.problem.descriptor.negative", new Object[0]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ShiftOutOfRangeFix((Integer)infos[0], (Boolean)infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ShiftOutOfRange();
    }

    private static class ShiftOutOfRange
    extends BaseInspectionVisitor {
        private ShiftOutOfRange() {
        }

        public void visitBinaryExpression(@NotNull PsiBinaryExpression expression) {
            super.visitBinaryExpression(expression);
            PsiJavaToken sign = expression.getOperationSign();
            IElementType tokenType = sign.getTokenType();
            if (!(tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT))) {
                return;
            }
            PsiType expressionType = expression.getType();
            if (expressionType == null) {
                return;
            }
            PsiExpression rhs = expression.getROperand();
            if (rhs == null) {
                return;
            }
            if (!PsiUtil.isConstantExpression((PsiExpression)rhs)) {
                return;
            }
            Integer valueObject = (Integer)ConstantExpressionUtil.computeCastTo((PsiExpression)rhs, (PsiType)PsiType.INT);
            if (valueObject == null) {
                return;
            }
            int value = valueObject;
            if (expressionType.equals(PsiType.LONG) && (value < 0 || value > 63)) {
                this.registerError((PsiElement)sign, valueObject, Boolean.TRUE);
            }
            if (expressionType.equals(PsiType.INT) && (value < 0 || value > 31)) {
                this.registerError((PsiElement)sign, valueObject, Boolean.FALSE);
            }
        }
    }

    private static class ShiftOutOfRangeFix
    extends InspectionGadgetsFix {
        private final int value;
        private final boolean isLong;

        ShiftOutOfRangeFix(int value, boolean isLong) {
            this.value = value;
            this.isLong = isLong;
        }

        @NotNull
        public String getName() {
            int newValue = this.isLong ? this.value & 0x3F : this.value & 0x1F;
            return InspectionGadgetsBundle.message("shift.out.of.range.quickfix", this.value, newValue);
        }

        @NotNull
        public String getFamilyName() {
            return "Fix shift value";
        }

        @Override
        protected void doFix(Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiBinaryExpression)) {
                return;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)parent;
            PsiExpression rhs = binaryExpression.getROperand();
            if (rhs == null) {
                return;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
            PsiExpression lhs = binaryExpression.getLOperand();
            String text = PsiType.LONG.equals((Object)lhs.getType()) ? String.valueOf(this.value & 0x3F) : String.valueOf(this.value & 0x1F);
            PsiExpression newExpression = factory.createExpressionFromText(text, element);
            rhs.replace((PsiElement)newExpression);
        }
    }
}

