/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringActionHandlerFactory;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.abstraction.StaticMethodOnlyUsedInOneClassInspectionBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticMethodOnlyUsedInOneClassInspection
extends StaticMethodOnlyUsedInOneClassInspectionBase {
    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass usageClass = (PsiClass)infos[0];
        return new StaticMethodOnlyUsedInOneClassFix(usageClass);
    }

    private static class StaticMethodOnlyUsedInOneClassFix
    extends InspectionGadgetsFix {
        private final SmartPsiElementPointer<PsiClass> usageClass;

        public StaticMethodOnlyUsedInOneClassFix(PsiClass usageClass) {
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)usageClass.getProject());
            this.usageClass = pointerManager.createSmartPsiElementPointer((PsiElement)usageClass);
        }

        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("static.method.only.used.in.one.class.quickfix", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        @Override
        protected void doFix(final @NotNull Project project2, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement location = descriptor.getPsiElement();
            final PsiMethod method = (PsiMethod)location.getParent();
            final RefactoringActionHandler moveHandler = RefactoringActionHandlerFactory.getInstance().createMoveHandler();
            AsyncResult result = DataManager.getInstance().getDataContextFromFocus();
            result.doWhenDone((Consumer)new Consumer<DataContext>(){

                public void consume(final DataContext originalContext) {
                    DataContext dataContext = new DataContext(){

                        public Object getData(@NonNls String name) {
                            if (LangDataKeys.TARGET_PSI_ELEMENT.is(name)) {
                                return usageClass.getElement();
                            }
                            return originalContext.getData(name);
                        }
                    };
                    moveHandler.invoke(project2, new PsiElement[]{method}, dataContext);
                }
            });
        }
    }
}

