/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.util.ArrayUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.AddToIgnoreIfAnnotatedByListQuickFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.TestUtils;
import com.siyeh.ig.ui.ExternalizableStringSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PublicMethodNotExposedInInterfaceInspectionBase
extends BaseInspection {
    public final ExternalizableStringSet ignorableAnnotations = new ExternalizableStringSet(new String[0]);
    public boolean onlyWarnIfContainingClassImplementsAnInterface = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("public.method.not.in.interface.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("public.method.not.in.interface.problem.descriptor", new Object[0]);
    }

    @Override
    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        return AddToIgnoreIfAnnotatedByListQuickFix.build((PsiModifierListOwner)infos[0], (List<String>)((Object)this.ignorableAnnotations));
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PublicMethodNotExposedInInterfaceVisitor();
    }

    private class PublicMethodNotExposedInInterfaceVisitor
    extends BaseInspectionVisitor {
        private PublicMethodNotExposedInInterfaceVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            if (method.isConstructor()) {
                return;
            }
            if (method.getNameIdentifier() == null) {
                return;
            }
            if (!method.hasModifierProperty("public")) {
                return;
            }
            if (method.hasModifierProperty("static")) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (containingClass.isInterface() || containingClass.isAnnotationType()) {
                return;
            }
            if (!containingClass.hasModifierProperty("public")) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (Collection)((Object)PublicMethodNotExposedInInterfaceInspectionBase.this.ignorableAnnotations))) {
                return;
            }
            if (PublicMethodNotExposedInInterfaceInspectionBase.this.onlyWarnIfContainingClassImplementsAnInterface) {
                PsiClass[] superClasses = containingClass.getSupers();
                boolean implementsInterface = false;
                for (PsiClass superClass : superClasses) {
                    if (!superClass.isInterface() || LibraryUtil.classIsInLibrary(superClass)) continue;
                    implementsInterface = true;
                    break;
                }
                if (!implementsInterface) {
                    return;
                }
            }
            if (this.exposedInInterface(method)) {
                return;
            }
            if (TestUtils.isJUnitTestMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }

        private boolean exposedInInterface(PsiMethod method) {
            Object[] superMethods = method.findSuperMethods();
            PsiMethod siblingInherited = FindSuperElementsHelper.getSiblingInheritedViaSubClass(method);
            if (siblingInherited != null && !ArrayUtil.contains((Object)siblingInherited, (Object[])superMethods)) {
                superMethods = (PsiMethod[])ArrayUtil.append((Object[])superMethods, (Object)siblingInherited);
            }
            for (Object superMethod : superMethods) {
                PsiClass superClass = superMethod.getContainingClass();
                if (superClass == null) continue;
                if (superClass.isInterface()) {
                    return true;
                }
                String superclassName = superClass.getQualifiedName();
                if ("java.lang.Object".equals(superclassName)) {
                    return true;
                }
                if (!this.exposedInInterface((PsiMethod)superMethod)) continue;
                return true;
            }
            return false;
        }
    }
}

