/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OptionalUsedAsFieldOrParameterTypeInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("optional.used.as.field.or.parameter.type.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiTypeElement typeElement = (PsiTypeElement)infos[0];
        PsiElement parent = typeElement.getParent();
        if (parent instanceof PsiField) {
            PsiField field = (PsiField)parent;
            return InspectionGadgetsBundle.message("optional.used.as.field.type.problem.descriptor", field.getName());
        }
        if (parent instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)parent;
            return InspectionGadgetsBundle.message("optional.used.as.parameter.type.problem.descriptor", parameter.getName());
        }
        throw new AssertionError();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OptionUsedAsFieldOrParameterTypeVisitor();
    }

    private static class OptionUsedAsFieldOrParameterTypeVisitor
    extends BaseInspectionVisitor {
        private OptionUsedAsFieldOrParameterTypeVisitor() {
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            this.checkTypeElement(field.getTypeElement());
        }

        public void visitParameter(PsiParameter parameter) {
            super.visitParameter(parameter);
            this.checkTypeElement(parameter.getTypeElement());
        }

        private void checkTypeElement(PsiTypeElement typeElement) {
            if (typeElement == null || !TypeUtils.isOptional(typeElement.getType())) {
                return;
            }
            this.registerError((PsiElement)typeElement, typeElement);
        }
    }
}

