/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class InstanceofChainInspection
extends BaseInspection {
    public boolean ignoreInstanceofOnLibraryClasses = false;

    @NotNull
    public String getID() {
        return "ChainOfInstanceofChecks";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("chain.of.instanceof.checks.display.name", new Object[0]);
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        Check check = (Check)((Object)infos[0]);
        if (check == Check.CLASS_EQUALITY) {
            return InspectionGadgetsBundle.message("chain.of.class.equality.checks.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("chain.of.instanceof.checks.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("ignore.instanceof.on.library.classes", new Object[0]), (InspectionProfileEntry)this, "ignoreInstanceofOnLibraryClasses");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new InstanceofChainVisitor();
    }

    private class InstanceofChainVisitor
    extends BaseInspectionVisitor {
        private InstanceofChainVisitor() {
        }

        public void visitIfStatement(@NotNull PsiIfStatement ifStatement) {
            PsiIfStatement previousIfStatement;
            PsiExpression condition;
            super.visitIfStatement(ifStatement);
            if (ControlFlowUtils.isElseIf(ifStatement)) {
                return;
            }
            PsiStatement previousStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)ifStatement, PsiStatement.class);
            if (previousStatement instanceof PsiIfStatement && this.chainCheck(condition = (previousIfStatement = (PsiIfStatement)previousStatement).getCondition(), null) != Check.NEITHER) {
                return;
            }
            int numChecks = 0;
            PsiIfStatement branch = ifStatement;
            Check check = null;
            while (true) {
                PsiStatement nextStatement;
                PsiExpression condition2;
                Check chainCheck;
                if ((chainCheck = this.chainCheck(condition2 = branch.getCondition(), check)) == Check.NEITHER) {
                    if (numChecks > 1) break;
                    return;
                }
                check = chainCheck;
                ++numChecks;
                PsiStatement elseBranch = branch.getElseBranch();
                if (elseBranch instanceof PsiIfStatement) {
                    branch = (PsiIfStatement)elseBranch;
                    continue;
                }
                if (elseBranch != null || !((nextStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)branch, PsiStatement.class)) instanceof PsiIfStatement)) break;
                branch = (PsiIfStatement)nextStatement;
            }
            if (numChecks < 2) {
                return;
            }
            this.registerStatementError((PsiStatement)ifStatement, new Object[]{check});
        }

        private Check chainCheck(PsiExpression condition, Check check) {
            while (true) {
                if (condition == null) {
                    return Check.NEITHER;
                }
                if (check != Check.CLASS_EQUALITY && this.isInstanceofExpression(condition)) {
                    return Check.INSTANCEOF;
                }
                if (condition instanceof PsiPolyadicExpression) {
                    PsiExpression[] operands;
                    if (check != Check.INSTANCEOF && this.isClassEqualityExpression(condition)) {
                        return Check.CLASS_EQUALITY;
                    }
                    PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)condition;
                    for (PsiExpression operand : operands = polyadicExpression.getOperands()) {
                        Check chainCheck = this.chainCheck(operand, check);
                        if (chainCheck == Check.NEITHER) continue;
                        return chainCheck;
                    }
                    return Check.NEITHER;
                }
                if (condition instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)condition;
                    condition = parenthesizedExpression.getExpression();
                    continue;
                }
                if (condition instanceof PsiPrefixExpression) {
                    PsiPrefixExpression prefixExpression = (PsiPrefixExpression)condition;
                    condition = prefixExpression.getOperand();
                    continue;
                }
                if (!(condition instanceof PsiPostfixExpression)) break;
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)condition;
                condition = postfixExpression.getOperand();
            }
            return Check.NEITHER;
        }

        private boolean isClassEqualityExpression(PsiExpression expression) {
            if (!(expression instanceof PsiBinaryExpression)) {
                return false;
            }
            PsiBinaryExpression binaryExpression = (PsiBinaryExpression)expression;
            if (binaryExpression.getOperationTokenType() != JavaTokenType.EQEQ) {
                return false;
            }
            return this.isClassObjectAccessExpression(binaryExpression.getLOperand()) || this.isClassObjectAccessExpression(binaryExpression.getROperand());
        }

        private boolean isClassObjectAccessExpression(PsiExpression expression) {
            if (!((expression = ParenthesesUtils.stripParentheses(expression)) instanceof PsiClassObjectAccessExpression)) {
                return false;
            }
            PsiClassObjectAccessExpression classObjectAccessExpression = (PsiClassObjectAccessExpression)expression;
            PsiTypeElement typeElement = classObjectAccessExpression.getOperand();
            return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || !LibraryUtil.isTypeInLibrary(typeElement.getType());
        }

        private boolean isInstanceofExpression(PsiExpression expression) {
            if (!(expression instanceof PsiInstanceOfExpression)) {
                return false;
            }
            PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)expression;
            PsiTypeElement typeElement = instanceOfExpression.getCheckType();
            return !InstanceofChainInspection.this.ignoreInstanceofOnLibraryClasses || typeElement == null || !LibraryUtil.isTypeInLibrary(typeElement.getType());
        }
    }

    private static enum Check {
        CLASS_EQUALITY,
        INSTANCEOF,
        NEITHER;

    }
}

