/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.abstraction;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.abstraction.ClassAccessVisitor;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FeatureEnvyInspectionBase
extends BaseInspection {
    public boolean ignoreTestCases = false;

    @Override
    @NotNull
    public String getDisplayName() {
        return InspectionGadgetsBundle.message("feature.envy.display.name", new Object[0]);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiNamedElement element = (PsiNamedElement)infos[0];
        String className = element.getName();
        return InspectionGadgetsBundle.message("feature.envy.problem.descriptor", className);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new FeatureEnvyVisitor();
    }

    private static class FeatureEnvyVisitor
    extends BaseInspectionVisitor {
        private FeatureEnvyVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiClass containingClass = method.getContainingClass();
            ClassAccessVisitor visitor = new ClassAccessVisitor(containingClass);
            method.accept((PsiElementVisitor)visitor);
            Set<PsiClass> overAccessedClasses = visitor.getOveraccessedClasses();
            for (PsiClass aClass : overAccessedClasses) {
                this.registerMethodError(method, aClass, method);
            }
        }
    }
}

