/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils.stream;

import com.jetbrains.sourceglider.utils.stream.CharacterDecodeException;
import java.io.IOException;
import java.io.InputStream;

public class HexadecimalStringInputStream
extends InputStream {
    private String string;
    private int pos;

    public HexadecimalStringInputStream(String string) {
        this.string = string;
    }

    @Override
    public int read() throws IOException {
        int part2;
        int part1;
        char digit;
        if (this.pos >= this.string.length()) {
            return -1;
        }
        if ((digit = this.string.charAt(this.pos++)) >= '0' && digit <= '9') {
            part1 = digit - 48;
        } else if (digit >= 'A' && digit <= 'F') {
            part1 = digit - 65 + 10;
        } else {
            throw new CharacterDecodeException();
        }
        digit = this.string.charAt(this.pos++);
        if (digit >= '0' && digit <= '9') {
            part2 = digit - 48;
        } else if (digit >= 'A' && digit <= 'F') {
            part2 = digit - 65 + 10;
        } else {
            throw new CharacterDecodeException();
        }
        return part1 * 16 + part2 - 128 & 0xFF;
    }

    @Override
    public int available() {
        return (this.string.length() - this.pos) / 2;
    }
}

