/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import com.jetbrains.sourceglider.utils.PrettyName;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class StringHelper {
    private static final int MAX_STRING_SURRONDINGS_LENGTH = 100;

    public static String makeCommaList(String[] values) {
        String result = "";
        if (values.length > 0) {
            result = values[0];
        }
        for (int i = 1; i < values.length; ++i) {
            result = result + ", " + values[i];
        }
        return result;
    }

    public static String makeNewlineList(String[] values) {
        String result = "";
        for (String value : values) {
            result = result + "\n\t" + value;
        }
        return result;
    }

    public static String makeNewlineMap(Map map, int linesCntLimit, int maxCharLength) {
        String result = "";
        Iterator itr = map.keySet().iterator();
        for (int index = 0; itr.hasNext() && index < linesCntLimit; ++index) {
            Object key = itr.next();
            String keyStr = key.toString();
            keyStr = keyStr.length() > maxCharLength ? "..." + keyStr.substring(keyStr.length() - maxCharLength - 3) : keyStr;
            result = result + "\n\t" + keyStr + " [" + map.get(key) + "]";
        }
        if (itr.hasNext()) {
            result = result + Messages.getString(StringHelper.class.getName() + "-0");
        }
        return result;
    }

    public static String makeCommaList(Collection<String> coll) {
        return StringHelper.makeCommaList(ArrayHelper.castStringArray(coll.toArray()));
    }

    public static String getPrettyFirstLine(String string) {
        int pos1 = string.indexOf(13);
        int pos2 = string.indexOf(10);
        int pos = -1;
        if (pos1 != -1 && pos2 != -1) {
            pos = Math.min(pos1, pos2);
        } else if (pos1 != -1) {
            pos = pos1;
        } else if (pos2 != -1) {
            pos = pos2;
        }
        if (pos == -1) {
            return string;
        }
        return string.substring(0, pos) + "...";
    }

    public static int occurencesCnt(String string, String substr) {
        int pos = 0;
        int result = 0;
        while (pos != -1) {
            if ((pos = string.indexOf(substr, pos)) == -1) continue;
            pos += substr.length();
            ++result;
        }
        return result;
    }

    public static String getIdentifierName(String string) {
        StringBuilder result = new StringBuilder();
        boolean wasIDSymb = false;
        for (int i = 0; i < string.length(); ++i) {
            char curSymbol = string.charAt(i);
            if (Character.isLetterOrDigit(curSymbol) || curSymbol == '_') {
                if (!wasIDSymb && Character.isLowerCase(curSymbol)) {
                    result.append((char)(curSymbol - 97 + 65));
                } else {
                    result.append(curSymbol);
                }
                wasIDSymb = true;
                continue;
            }
            wasIDSymb = false;
        }
        return result.toString();
    }

    public static PrettyName getStringSurroundings(String container, int start, int length, int linesBefore, int linesAfter) {
        String result;
        int i;
        if (start == -1) {
            return new PrettyName(Messages.getString(StringHelper.class.getName() + "-1"));
        }
        int lineStart = start + 1;
        int lineEnd = start - 1;
        int newlinesInMarked = 0;
        for (i = 0; i <= linesBefore; ++i) {
            if (lineStart > 0 && container.charAt(lineStart - 1) == '\r' && container.charAt(lineStart) == '\n') {
                --lineStart;
            }
            if (lineStart == -1) continue;
            lineStart = Math.max(container.lastIndexOf(13, lineStart - 1), container.lastIndexOf(10, lineStart - 1));
        }
        for (i = 0; i <= linesAfter; ++i) {
            if (lineEnd != -1) {
                if (container.charAt(lineEnd) == '\r' || lineEnd < container.length() - 1 && container.charAt(lineEnd + 1) == '\n') {
                    ++lineEnd;
                }
                int pos1 = container.indexOf(13, lineEnd + 1);
                int pos2 = container.indexOf(10, lineEnd + 1);
                lineEnd = pos1 == -1 ? pos2 : (pos2 == -1 ? pos1 : Math.min(pos1, pos2));
            }
            if (lineEnd == -1 || lineEnd >= start + length) continue;
            ++newlinesInMarked;
        }
        ++lineStart;
        if (lineEnd == -1) {
            lineEnd = container.length();
        }
        if (container.charAt(lineEnd - 1) == '\r') {
            --lineEnd;
        }
        if (linesBefore + linesAfter == 0) {
            if (start - lineStart > 100) {
                lineStart = start - 100;
            }
            if (lineEnd - (start + length) > 100) {
                lineEnd = start + length + 100;
            }
            while (lineStart < lineEnd && container.charAt(lineStart) <= ' ') {
                ++lineStart;
            }
            while (lineStart < lineEnd && container.charAt(lineEnd - 1) <= ' ') {
                --lineEnd;
            }
            if (lineStart > lineEnd) {
                int t = lineStart;
                lineStart = lineEnd;
                lineEnd = t;
            }
            result = container.substring(lineStart, lineEnd);
        } else {
            result = container.substring(lineStart, lineEnd);
            String[] delims = new String[]{" ", "\t"};
            boolean reducing = true;
            while (reducing) {
                reducing = false;
                for (String delim : delims) {
                    if (!result.startsWith(delim) || StringHelper.occurencesCnt(result, "\n" + delim) != linesBefore + linesAfter) continue;
                    result = result.substring(1).replaceAll("\n" + delim, "\n");
                    start -= linesBefore + 1;
                    length -= newlinesInMarked;
                    lineEnd -= linesBefore + linesAfter + 1;
                    reducing = true;
                }
            }
        }
        if (start + length <= lineEnd) {
            return new PrettyName(result, start - lineStart, start - lineStart + length);
        }
        return new PrettyName(result + "...", start - lineStart);
    }

    public static PrettyName surroundPrettyName(PrettyName prettyName, String before, String after2) {
        String newText = prettyName.getPrefix() + before + prettyName.getMarked() + after2 + prettyName.getSuffix();
        return new PrettyName(newText, prettyName.getMarkStart(), prettyName.getMarkEnd() + before.length() + after2.length());
    }

    public static boolean startsWith(String string, String prefix) {
        if (prefix.length() > string.length()) {
            return false;
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            if (string.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String applyCaesarCipher(String string, int shift) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            result.append((char)(string.charAt(i) + shift));
        }
        return result.toString();
    }

    public static String readVersionString(String string, int pos) {
        StringBuilder result = new StringBuilder();
        while (pos < string.length() && Character.isWhitespace(string.charAt(pos))) {
            ++pos;
        }
        if (pos < string.length() && Character.isDigit(string.charAt(pos))) {
            while (pos < string.length() && (Character.isDigit(string.charAt(pos)) || string.charAt(pos) == '.')) {
                result.append(string.charAt(pos));
                ++pos;
            }
        }
        return result.toString();
    }

    public static String removeSpaces(String string) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            result.append(string.charAt(i));
        }
        return result.toString();
    }
}

