/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.utils;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.ui.Messages;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class ArrayHelper {
    public static Object[] castArray(Object[] array, Class type) {
        Object[] result = (Object[])Array.newInstance(type, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static String[] castStringArray(Object[] array) {
        String[] result = (String[])Array.newInstance(String.class, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static int[] castIntArray(Object[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (Integer)array[i];
        }
        return result;
    }

    public static Object[] toArray(Collection collection, Class type) {
        Object[] array = collection.toArray();
        return ArrayHelper.castArray(array, type);
    }

    public static int searchElement(Object[] array, Object element) {
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(element)) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsElement(Object[] array, Object element) {
        return ArrayHelper.searchElement(array, element) != -1;
    }

    public static boolean haveCommonElements(Object[] array1, Object[] array2) {
        for (Object anArray1 : array1) {
            for (Object anArray2 : array2) {
                if (!anArray1.equals(anArray2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean haveSameElems(int[] array) {
        int[] copy = new int[array.length];
        System.arraycopy(array, 0, copy, 0, array.length);
        Arrays.sort(copy);
        for (int i = 0; i < copy.length - 1; ++i) {
            if (copy[i] != copy[i + 1]) continue;
            return true;
        }
        return false;
    }

    public static Object[][] removeColumn(Object[][] array, int index, Class<Attribute> clazz) {
        if (array.length == 0) {
            return array;
        }
        Object[][] result = (Object[][])Array.newInstance(clazz, array.length, array[0].length - 1);
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                if (j < index) {
                    result[i][j] = array[i][j];
                    continue;
                }
                if (j <= index) continue;
                result[i][j - 1] = array[i][j];
            }
        }
        return result;
    }

    public static Object[][] swapColumns(Object[][] array, int index1, int index2, Class<Attribute> clazz) {
        if (array.length == 0) {
            return array;
        }
        Object[][] result = (Object[][])Array.newInstance(clazz, array.length, array[0].length);
        for (int i = 0; i < array.length; ++i) {
            System.arraycopy(array[i], 0, result[i], 0, array[i].length);
            result[i][index1] = array[i][index2];
            result[i][index2] = array[i][index1];
        }
        return result;
    }

    public static Object[] deleteElement(Object[] array, int index, Class<Domain> type) {
        Object[] result = (Object[])Array.newInstance(type, array.length - 1);
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }

    public static Object[] deleteElement(Object[] array, Object element, Class type) {
        Object[] result = (Object[])Array.newInstance(type, array.length - 1);
        int index = ArrayHelper.searchElement(array, element);
        if (index == -1) {
            throw new IllegalArgumentException(Messages.getString(ArrayHelper.class.getName() + "-0"));
        }
        System.arraycopy(array, 0, result, 0, index);
        System.arraycopy(array, index + 1, result, index, array.length - index - 1);
        return result;
    }

    public static Object[] mergeArrays(Object[] array1, Object[] array2, Class type) {
        Object[] result = (Object[])Array.newInstance(type, array1.length + array2.length);
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static Object[] uniteArrays(Object[] array1, Object[] array2, Class<Domain> type) {
        HashSet<Object> set = new HashSet<Object>();
        Object[] cat = new Object[array1.length + array2.length];
        int len = 0;
        for (Object anArray1 : array1) {
            cat[len++] = anArray1;
            set.add(anArray1);
        }
        for (Object anArray2 : array2) {
            if (set.contains(anArray2)) continue;
            cat[len++] = anArray2;
        }
        Object[] result = (Object[])Array.newInstance(type, len);
        System.arraycopy(cat, 0, result, 0, len);
        return result;
    }

    public static boolean setEqual(Object[] array1, Object[] array2) {
        HashSet set = new HashSet();
        Collections.addAll(set, array1);
        for (Object anArray2 : array2) {
            if (!set.contains(anArray2)) {
                return false;
            }
            set.remove(anArray2);
        }
        for (Object anArray1 : array1) {
            if (!set.contains(anArray1)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] array1, byte[] array2, int length) {
        for (int i = 0; i < length; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static Object[] getIthRow(Object[][] matrix, int row, Class clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, matrix.length);
        for (int i = 0; i < matrix.length; ++i) {
            result[i] = matrix[i][row];
        }
        return result;
    }

    public static List<Integer> getFirstRow(List matrix) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Object aMatrix : matrix) {
            result.add(new Integer(((int[])aMatrix)[0]));
        }
        return result;
    }

    public static Object[] getFirstRow(Object[][] matrix, Class clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, matrix.length);
        for (int i = 0; i < matrix.length; ++i) {
            result[i] = matrix[i][0];
        }
        return result;
    }

    public static int[] getFirstRow(int[][] matrix) {
        int[] result = new int[matrix.length];
        for (int i = 0; i < matrix.length; ++i) {
            result[i] = matrix[i][0];
        }
        return result;
    }

    public static int[] resizeIntArray(int[] array, int length) {
        int[] newArray = new int[length];
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    public static Object[] copyArray(Object[] array, Class clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static Object[] flipArray(Object[] array, Class clazz) {
        Object[] result = (Object[])Array.newInstance(clazz, array.length);
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[array.length - 1 - i];
        }
        return result;
    }
}

