/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.symtable;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.symtable.AttributeInfo;
import com.jetbrains.sourceglider.symtable.SingleDomainAttribute;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.symtable.Vertex;
import com.jetbrains.sourceglider.utils.FastHashSet;
import com.jetbrains.sourceglider.utils.StringSplitter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class HierarchicalStringsHolder {
    private static final String DELIMETERS = ".$ /,()#<{=";
    private static final int BUFFER_LENGTH = 1024;
    private static StringSplitter splitter = new StringSplitter(".$ /,()#<{=");
    private FastHashSet vertices;
    private Vertex lastAddedVertex;
    private int memorySize;
    private char[] buffer = new char[1024];

    private HierarchicalStringsHolder(int _) {
    }

    public HierarchicalStringsHolder() {
        this.vertices = new FastHashSet();
        this.memorySize = 0;
    }

    public Vertex addString(String attribute, AttributeInfo value) {
        if (attribute == null || attribute.length() == 0) {
            return null;
        }
        this.doAddString(attribute, value);
        return this.lastAddedVertex;
    }

    public Vertex addString(String attribute) {
        if (attribute != null && attribute.length() > 0) {
            this.doAddString(attribute, new AttributeInfo(){

                @Override
                public DomainType[] getAllowableDomainTypes(SymbolTable symbolTable) {
                    return null;
                }

                @Override
                public String[] getAllowableDomainTypeNames(SymbolTable symbolTable) {
                    return null;
                }

                @Override
                public boolean allowsDomainType(DomainType type, SymbolTable symbolTable) {
                    return false;
                }

                @Override
                public SingleDomainAttribute getAttributeInfo(DomainType type, SymbolTable symbolTable) {
                    return null;
                }

                @Override
                public int memorySize() {
                    return 0;
                }
            });
            return this.lastAddedVertex;
        }
        return null;
    }

    public AttributeInfo getValue(String attribute) {
        if (attribute == null || attribute.length() == 0) {
            return null;
        }
        return this.doAddString(attribute, null);
    }

    public boolean contains(String attribute) {
        if (attribute == null || attribute.length() == 0) {
            return false;
        }
        return this.doAddString(attribute, null) != null;
    }

    public Vertex getLastQueryVertex() {
        return this.lastAddedVertex;
    }

    private AttributeInfo doAddString(String attribute, AttributeInfo value) {
        String[] tokens = splitter.split(attribute);
        return this.addPath(tokens, value);
    }

    private AttributeInfo addPath(String[] path, AttributeInfo value) {
        Vertex parent = null;
        for (String aPath : path) {
            Vertex vertex = new Vertex(parent, aPath);
            Vertex child = (Vertex)this.vertices.search(vertex);
            if (child == null) {
                this.vertices.add(vertex);
                this.memorySize += vertex.memorySize();
                parent = vertex;
                continue;
            }
            parent = child;
        }
        this.lastAddedVertex = parent;
        AttributeInfo result = parent.getValue();
        if (value != null) {
            parent.setValue(value);
            this.memorySize += value.memorySize();
            return value;
        }
        return result;
    }

    public String getPath(Vertex vertex) {
        if (vertex == null) {
            return null;
        }
        int pos = 1024;
        while (vertex != null) {
            String key = vertex.getKey();
            if ((pos -= key.length()) < 0) {
                pos = 0;
                break;
            }
            key.getChars(0, key.length(), this.buffer, pos);
            vertex = vertex.getParent();
        }
        return new String(this.buffer, pos, 1024 - pos);
    }

    public void serialize(ObjectOutputStream out) throws IOException {
        this.vertices.serialize(out);
    }

    public static HierarchicalStringsHolder deserialize(ObjectInputStream in) throws IOException, ClassNotFoundException {
        HierarchicalStringsHolder holder = new HierarchicalStringsHolder(0);
        holder.vertices = FastHashSet.deserialize(in);
        return holder;
    }

    public int memorySize() {
        return this.memorySize;
    }
}

