/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprQuantify;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Implication;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.ArrayList;
import java.util.List;

public class RelQuantify
extends Nonterm {
    public RelExpr relExpr;
    public Implication subexpr;
    private int opCode;
    private DomainType domainType;
    private List domainNames = new ArrayList();
    private List<String> ids;

    public RelQuantify(Context context) {
        super(context);
    }

    public void exist(TokenInfo token) {
        this.opCode = 0;
    }

    public void forall(TokenInfo token) {
        this.opCode = 1;
    }

    public void start() {
        this.ids = new ArrayList<String>();
        this.domainType = null;
    }

    public void id(TokenInfo token) throws ParseException {
        String id = token.getString();
        this.ids.add(id);
        if (this.context.variablesManager.containsDomain(id)) {
            throw new ParseException(token.location, Messages.getString(RelQuantify.class.getName() + "-0") + id + Messages.getString(RelQuantify.class.getName() + "-1"));
        }
    }

    public void domain(TokenInfo token) {
        this.domainType = this.context.variablesManager.getDomainType(token.getString());
    }

    public void fakeDomain(TokenInfo token) throws ParseException {
        if (!this.context.isConsoleQuery) {
            throw new ParseException(token.location, Messages.getString(RelQuantify.class.getName() + "-2"));
        }
    }

    public void endGroup() {
        for (String id : this.ids) {
            this.domainNames.add(id);
            this.context.variablesManager.addDomain(id, this.domainType);
        }
    }

    public void subexpr() throws ParseException {
        if (this.subexpr.type != 0) {
            throw new ParseException(this.subexpr.location, Messages.getString(RelQuantify.class.getName() + "-3"));
        }
        this.relExpr = this.subexpr.relExpr;
        for (int i = this.domainNames.size() - 1; i >= 0; --i) {
            String name = (String)this.domainNames.get(i);
            DomainType type = this.context.variablesManager.getDomain((String)this.domainNames.get(i));
            if (!this.context.variablesManager.wasDomainUsed(name)) {
                throw new ParseException(this.subexpr.location, Messages.getString(RelQuantify.class.getName() + "-4") + name + Messages.getString(RelQuantify.class.getName() + "-5"));
            }
            this.context.variablesManager.removeDomain(name);
            this.relExpr = new RelExprQuantify(this.opCode, name, this.context.variablesManager.getDomainTypeReference(type.getName()), this.relExpr, this.context, this);
        }
    }
}

