/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class Declaration
extends Nonterm {
    private String name;
    private String key;
    private HashMap<String, String> metaInfo;
    private int varType;
    private List<DomainType> domTypes;
    private boolean wasLocation;
    private Integer optionDefaultValue;

    public Declaration(Context context) {
        super(context);
    }

    public void relID(TokenInfo token) throws ParseException {
        this.name = token.getString();
        if (this.context.variablesManager.containsRelation(this.name)) {
            throw new ParseException(token.location, Messages.getString(Declaration.class.getName() + "-0"));
        }
        this.domTypes = new ArrayList<DomainType>();
        this.metaInfo = new HashMap();
        this.wasLocation = false;
    }

    public void newDomain(TokenInfo token) {
        DomainType type = DomainType.createGenericDomainType(token.getString(), this.context.symbolTable);
        this.context.variablesManager.addDomainType(token.getString(), type, new DomainTypeReference(this.name, this.domTypes.size()));
        this.domTypes.add(type);
    }

    public void domain(TokenInfo token) {
        this.domTypes.add(this.context.variablesManager.getDomainType(token.getString()));
    }

    public void input(TokenInfo token) {
        DomainType[] types = (DomainType[])ArrayHelper.castArray(this.domTypes.toArray(), DomainType.class);
        this.context.variablesManager.addInputRelation(new RelationSignature(this.name, types));
    }

    public void output() throws ParseException {
        if (!this.wasLocation) {
            this.metaInfo.put("location", "/Default");
        }
        DomainType[] types = (DomainType[])ArrayHelper.castArray(this.domTypes.toArray(), DomainType.class);
        this.context.variablesManager.addOutputRelation(new RelationSignature(this.name, types), this.metaInfo);
    }

    public void key(TokenInfo token) {
        this.key = token.getString();
        if (this.key.equals("location")) {
            this.wasLocation = true;
        }
    }

    public void value(TokenInfo token) {
        this.metaInfo.put(this.key, token.getString());
    }

    public void relation() {
        DomainType[] types = (DomainType[])ArrayHelper.castArray(this.domTypes.toArray(), DomainType.class);
        this.context.variablesManager.addTempRelation(new RelationSignature(this.name, types));
    }

    public void integer(TokenInfo token) {
        this.varType = 1;
    }

    public void bool(TokenInfo token) {
        this.varType = 2;
    }

    public void numID(TokenInfo token) throws ParseException {
        this.name = token.getString();
        if (this.context.variablesManager.containsVariable(this.name)) {
            throw new ParseException(token.location, Messages.getString(Declaration.class.getName() + "-4"));
        }
        this.context.variablesManager.addVariable(this.name, this.varType);
    }

    public void optID(TokenInfo token) throws ParseException {
        this.name = token.getString();
        if (this.context.variablesManager.containsVariable(this.name)) {
            throw new ParseException(token.location, Messages.getString(Declaration.class.getName() + "-4"));
        }
    }

    public void numOption(TokenInfo token) throws ParseException {
        this.optionDefaultValue = new Integer(token.number);
        if (this.varType != 1) {
            throw new ParseException(token.location, Messages.getString(Declaration.class.getName() + "-5"));
        }
    }

    public void falseOption(TokenInfo token) throws ParseException {
        this.optionDefaultValue = new Integer(0);
        if (this.varType != 2) {
            throw new ParseException(token.location, Messages.getString(Declaration.class.getName() + "-5"));
        }
    }

    public void trueOption(TokenInfo token) throws ParseException {
        this.optionDefaultValue = new Integer(1);
        if (this.varType != 2) {
            throw new ParseException(token.location, Messages.getString(Declaration.class.getName() + "-5"));
        }
    }

    public void option() {
        this.context.variablesManager.addOption(this.name, this.optionDefaultValue, this.varType);
    }
}

