/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.ui.console.Console;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ProfileManager {
    private Map<QueryNode, ProfileData> map = new HashMap<QueryNode, ProfileData>();

    public void addDuration(QueryNode node, long duration, long bddSize) {
        ProfileData profileData = this.map.get(node);
        if (profileData == null) {
            profileData = new ProfileData();
            this.map.put(node, profileData);
        }
        ProfileData profileData2 = profileData;
        profileData2.totalDuration = profileData2.totalDuration + duration;
        profileData2 = profileData;
        profileData2.totalBddSize = profileData2.totalBddSize + bddSize;
    }

    public void dump(Console console, String query) {
        ArrayList<QueryNode> nodes = new ArrayList<QueryNode>(this.map.keySet());
        Collections.sort(nodes, new Comparator<QueryNode>(){

            @Override
            public int compare(QueryNode o1, QueryNode o2) {
                long diff = ((ProfileData)ProfileManager.this.map.get(o1)).totalDuration - ((ProfileData)ProfileManager.this.map.get(o2)).totalDuration;
                return diff < 0L ? 1 : (diff > 0L ? -1 : 0);
            }
        });
        console.println("Operations profile:");
        for (QueryNode node : nodes) {
            ProfileData profileData = this.map.get(node);
            int[] location = node.getNonterm().getLocation();
            String astString = query.substring(location[0], location[1]);
            console.println(profileData.totalDuration + "\t(" + profileData.totalBddSize + ")\t" + location[2] + ":" + location[3] + "\t" + astString);
        }
    }

    private static class ProfileData {
        private long totalDuration;
        private long totalBddSize;

        private ProfileData() {
        }
    }
}

