/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd.nativeproxy;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.List;

public class BDDNativeProxy
implements IBDD {
    int index;
    static BDDNativeProxy zero;
    static BDDNativeProxy one;
    static int zeroIndex;
    static int oneIndex;
    static Object syncObject;

    BDDNativeProxy(int index) {
        this.index = index;
    }

    @Override
    public void incRefCount() {
        if (this.index == zeroIndex || this.index == oneIndex) {
            return;
        }
        BDDNativeProxy.doIncRefCount(this.index);
    }

    @Override
    public void decRefCount() {
        if (this.index == zeroIndex || this.index == oneIndex) {
            return;
        }
        BDDNativeProxy.doDecRefCount(this.index);
    }

    @Override
    public boolean isZero() {
        return this.index == zeroIndex;
    }

    @Override
    public boolean isOne() {
        return this.index == oneIndex;
    }

    @Override
    public IBDD intersect(IBDD node, ThreadCallback threadCallback) {
        if (this.index == zeroIndex || ((BDDNativeProxy)node).index == zeroIndex) {
            return zero;
        }
        if (this.index == oneIndex) {
            BDDNativeProxy.doIncRefCount(((BDDNativeProxy)node).index);
            return node;
        }
        if (((BDDNativeProxy)node).index == oneIndex) {
            BDDNativeProxy.doIncRefCount(this.index);
            return this;
        }
        return new BDDNativeProxy(BDDNativeProxy.doIntersect(this.index, ((BDDNativeProxy)node).index));
    }

    @Override
    public IBDD unite(IBDD node, ThreadCallback threadCallback) {
        if (this.index == oneIndex || ((BDDNativeProxy)node).index == oneIndex) {
            return one;
        }
        if (this.index == zeroIndex) {
            BDDNativeProxy.doIncRefCount(((BDDNativeProxy)node).index);
            return node;
        }
        if (((BDDNativeProxy)node).index == zeroIndex) {
            BDDNativeProxy.doIncRefCount(this.index);
            return this;
        }
        return new BDDNativeProxy(BDDNativeProxy.doUnite(this.index, ((BDDNativeProxy)node).index));
    }

    @Override
    public IBDD complement() {
        if (this.index == zeroIndex) {
            return one;
        }
        if (this.index == oneIndex) {
            return zero;
        }
        return new BDDNativeProxy(BDDNativeProxy.doComplement(this.index));
    }

    @Override
    public IBDD exists(int var, ThreadCallback threadCallback) {
        return new BDDNativeProxy(BDDNativeProxy.doExistsVar(this.index, var));
    }

    @Override
    public IBDD exists(int firstVar, int length, ThreadCallback threadCallback) {
        return new BDDNativeProxy(BDDNativeProxy.doExists(this.index, firstVar, length));
    }

    @Override
    public boolean testVars(int firstVar, int length) {
        return BDDNativeProxy.doTestVars(this.index, firstVar, length);
    }

    @Override
    public IBDD rename(int firstVar, int length, int varOffset, ThreadCallback threadCallback) {
        return new BDDNativeProxy(BDDNativeProxy.doRename(this.index, firstVar, length, varOffset));
    }

    @Override
    public IBDD relprod(IBDD node, int firstVar, int length, ThreadCallback threadCallback) {
        return new BDDNativeProxy(BDDNativeProxy.doRelprod(this.index, ((BDDNativeProxy)node).index, firstVar, length));
    }

    @Override
    public boolean superset(IBDD node) {
        return BDDNativeProxy.doSuperset(this.index, ((BDDNativeProxy)node).index);
    }

    @Override
    public boolean equals(IBDD node) {
        return this.index == ((BDDNativeProxy)node).index;
    }

    @Override
    public int[][] getNTuples(int[] starts, int[] lengths, int[] limits, int n) {
        List result = BDDNativeProxy.doGetNTuples(this.index, starts, lengths, limits, n);
        return (int[][])ArrayHelper.castArray(result.toArray(), int[].class);
    }

    @Override
    public int getNumOfTuples(int[] starts, int[] lengths, int[] limits) {
        return BDDNativeProxy.doGetNumOfTuples(this.index, starts, lengths, limits);
    }

    @Override
    public long getNumOfNodes() {
        return BDDNativeProxy.doGetNumOfNodes(this.index);
    }

    @Override
    public IBDD addTuple(int[] starts, int[] lengths, int[] values) {
        return new BDDNativeProxy(BDDNativeProxy.doAddTuple(this.index, starts, lengths, values));
    }

    static native void doIncRefCount(int var0);

    static native void doDecRefCount(int var0);

    static native int doIntersect(int var0, int var1);

    static native int doUnite(int var0, int var1);

    static native int doComplement(int var0);

    static native int doExistsVar(int var0, int var1);

    static native int doExists(int var0, int var1, int var2);

    static native boolean doTestVars(int var0, int var1, int var2);

    static native int doRename(int var0, int var1, int var2, int var3);

    static native int doRelprod(int var0, int var1, int var2, int var3);

    static native boolean doSuperset(int var0, int var1);

    static native List doGetNTuples(int var0, int[] var1, int[] var2, int[] var3, int var4);

    static native int doGetNumOfTuples(int var0, int[] var1, int[] var2, int[] var3);

    static native int doGetNumOfNodes(int var0);

    static native int doAddTuple(int var0, int[] var1, int[] var2, int[] var3);

    static {
        syncObject = new Object();
    }
}

