/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider;

import com.jetbrains.sourceglider.atttributes.AttributeQueryHistory;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.bdd.javaimpl.BDDManagerJavaImpl;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.relations.incremental.RelationsCache;
import com.jetbrains.sourceglider.relations.plain.PlainRelationsManager;
import com.jetbrains.sourceglider.repositories.HypoteticRelationsRepository;
import com.jetbrains.sourceglider.repositories.MemoryRelationsRepository;
import com.jetbrains.sourceglider.repositories.RelationsRepository;
import com.jetbrains.sourceglider.scripts.ScriptManager;
import com.jetbrains.sourceglider.scripts.rml.RMLParseErrorCallback;
import com.jetbrains.sourceglider.scripts.rml.RMLScript;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.symtable.WrongAttributeException;
import com.jetbrains.sourceglider.ui.FileConfigs;
import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.ui.console.Console;
import com.jetbrains.sourceglider.ui.console.ConsoleCommandProcessor;
import com.jetbrains.sourceglider.visitors.VisitorsManager;
import com.jetbrains.sourceglider.visitors.filters.ArrayFilters;
import com.jetbrains.sourceglider.visitors.filters.ThreadFilters;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ManagerInstancesProvider {
    private static final String CONFIGS_FILE_NAME = "configs.properties";
    private static final String MESSAGES_FILE_URL = "strings.properties";
    public static final String KEY_ANALYSIS_STORE_LOCATION = "AnalysisStoreLocation";
    public static final String KEY_DISABLE_ATTRIBUTES_WARNING_ERROR = "DisableAttributesWarningError";
    public static final String KEY_BDD_MANAGER_CLASS = "BDDManagerClass";
    private static final String KEY_RELATIONS_MANAGER_CLASS = "RelationsManagerClass";
    private static final String KEY_MEMORY_USING_LIMIT = "MemoryUsingLimit";
    private static final String KEY_ENABLE_MEMORY_LIMIT_WARNING = "EnableMemoryLimitWarning";
    public static final String DEFAULT_BDD_MANAGER_CLASS = BDDManagerJavaImpl.class.getName();
    public static final String DEFAULT_RELATIONS_MANAGER_CLASS = PlainRelationsManager.class.getName();
    public static final String FAILSAFE_BDD_MANAGER_CLASS = BDDManagerJavaImpl.class.getName();
    public static final String FAILSAFE_RELATIONS_MANAGER_CLASS = PlainRelationsManager.class.getName();
    private static final int DEFAULT_MEMORY_USING_LIMIT = 0x19000000;
    private static final boolean DEFAULT_ENABLE_MEMORY_LIMIT_WARNING = true;
    private static final boolean FILTERS_ENABLED = false;
    protected IBDDManager bddManager;
    protected RelationsCache relationsCache;
    protected IRelationsManager relationsManager;
    protected SymbolTable symbolTable;
    protected RelationsRepository relationsRepository;
    protected HypoteticRelationsRepository hypoteticRepository;
    protected ArrayFilters arrayFilters;
    protected ThreadFilters threadFilters;
    protected VisitorsManager visitorsManager;
    protected ScriptManager scriptManager;
    protected AttributeQueryHistory queryHistory = new AttributeQueryHistory();
    private final UIInstancesProvider uiInstancesProvider = this.createUIInstancesProvider();
    private List<Runnable> afterInitUITasks = new ArrayList<Runnable>();
    protected boolean afterInitTasksStarted = false;
    protected boolean afterInitTasksPerformed = false;
    private int memoryUsingLimit;
    private boolean enableMemoryLimitWarning;

    protected UIInstancesProvider createUIInstancesProvider() {
        return new UIInstancesProvider();
    }

    public UIInstancesProvider getUIInstancesProvider() {
        return this.uiInstancesProvider;
    }

    public UICallback getUICallback() {
        return this.uiInstancesProvider.getUICallback();
    }

    public Console getConsole() {
        return this.uiInstancesProvider.getConsole();
    }

    public void initConfigs() {
        URL url = this.getURL(CONFIGS_FILE_NAME);
        if (url == null) {
            this.uiInstancesProvider.setConfigs(new IConfigs.ConfigsStub());
            return;
        }
        this.uiInstancesProvider.setConfigs(new FileConfigs(url.getPath(), this.uiInstancesProvider.getUICallback()));
    }

    public boolean initBDDManager() {
        String providerClassName = this.uiInstancesProvider.getConfigs().getValue(KEY_BDD_MANAGER_CLASS, DEFAULT_BDD_MANAGER_CLASS);
        try {
            this.uiInstancesProvider.getConsole().print(Messages.getString(ManagerInstancesProvider.class.getName() + "-1"));
            Class<?> providerClass = Class.forName(providerClassName);
            this.bddManager = (IBDDManager)providerClass.newInstance();
            this.bddManager.startInit();
            this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-OK"));
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-Failed"));
            this.uiInstancesProvider.getUICallback().showError(Messages.getString(ManagerInstancesProvider.class.getName() + "-2"), e, false);
            try {
                this.uiInstancesProvider.getConsole().print(Messages.getString(ManagerInstancesProvider.class.getName() + "-3"));
                Class<?> providerClass = Class.forName(FAILSAFE_BDD_MANAGER_CLASS);
                this.bddManager = (IBDDManager)providerClass.newInstance();
                this.bddManager.startInit();
                this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-OK"));
            }
            catch (Throwable e2) {
                this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-Failed"));
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(ManagerInstancesProvider.class.getName() + "-6"), e2, true);
                return false;
            }
        }
        return true;
    }

    public boolean initRelationsManager() {
        this.relationsCache = new RelationsCache(this.bddManager);
        String providerClassName = this.uiInstancesProvider.getConfigs().getValue(KEY_RELATIONS_MANAGER_CLASS, DEFAULT_RELATIONS_MANAGER_CLASS);
        try {
            this.uiInstancesProvider.getConsole().print(Messages.getString(ManagerInstancesProvider.class.getName() + "-7"));
            Class<?> providerClass = Class.forName(providerClassName);
            this.relationsManager = (IRelationsManager)providerClass.newInstance();
            this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-OK"));
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-Failed"));
            this.uiInstancesProvider.getUICallback().showError(Messages.getString(ManagerInstancesProvider.class.getName() + "-10"), e, false);
            try {
                this.uiInstancesProvider.getConsole().print(Messages.getString(ManagerInstancesProvider.class.getName() + "-11"));
                Class<?> providerClass = Class.forName(FAILSAFE_RELATIONS_MANAGER_CLASS);
                this.relationsManager = (IRelationsManager)providerClass.newInstance();
                this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-OK"));
            }
            catch (Throwable e2) {
                this.uiInstancesProvider.getConsole().println(Messages.getString(ManagerInstancesProvider.class.getName() + "-Failed"));
                this.uiInstancesProvider.getUICallback().showError(Messages.getString(ManagerInstancesProvider.class.getName() + "-12"), e2, true);
                return false;
            }
        }
        return true;
    }

    public boolean startInit() {
        UICallback uiCallback = this.uiInstancesProvider.getUICallback();
        if (!Messages.init(this.getURL(MESSAGES_FILE_URL), uiCallback)) {
            return false;
        }
        this.initConfigs();
        uiCallback.initCounterLimits();
        if (!this.initBDDManager()) {
            return false;
        }
        if (!this.initRelationsManager()) {
            return false;
        }
        this.symbolTable = new SymbolTable(uiCallback, this.uiInstancesProvider.getConsole());
        this.relationsRepository = new MemoryRelationsRepository(this.relationsManager, uiCallback);
        this.visitorsManager = this.createVisitorsManager();
        this.scriptManager = new ScriptManager();
        this.hypoteticRepository = new HypoteticRelationsRepository(this);
        this.relationsRepository.addListener(this.hypoteticRepository);
        this.uiInstancesProvider.setConsoleCommandProcessor(new ConsoleCommandProcessor(this.visitorsManager, this.scriptManager, this.relationsRepository, this.hypoteticRepository, this));
        this.readFilters();
        this.registerVisitors();
        this.registerScripts();
        if (!this.refreshScripts()) {
            return false;
        }
        return this.hypoteticRepository.refresh();
    }

    public void init() {
        this.uiInstancesProvider.getUICallback().resetCounters();
        this.enableMemoryLimitWarning = this.uiInstancesProvider.getConfigs().getBooleanValue(KEY_ENABLE_MEMORY_LIMIT_WARNING, true);
        this.memoryUsingLimit = this.uiInstancesProvider.getConfigs().getIntValue(KEY_MEMORY_USING_LIMIT, 0x19000000);
        this.symbolTable.init();
        this.bddManager.init(this.uiInstancesProvider.getConfigs());
        this.relationsManager.init(this.bddManager, this.symbolTable);
        this.relationsRepository.clear();
        this.visitorsManager.init();
        this.hypoteticRepository.resetMemoryRelations();
    }

    public URL getURL(String localPath) {
        try {
            return ManagerInstancesProvider.class.getResource(localPath);
        }
        catch (Throwable e) {
            this.uiInstancesProvider.getUICallback().showError("Unable to locate \"" + localPath + "\"", true);
            return null;
        }
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    protected VisitorsManager createVisitorsManager() {
        return new VisitorsManager();
    }

    public boolean refreshScripts() {
        return this.scriptManager.refresh(new RMLParseErrorCallback(){

            @Override
            public void error(int startPos, int endPos, int line, int offset, String message) {
                message = message + Messages.getString(ManagerInstancesProvider.class.getName() + "-14") + line + ":" + offset;
                ManagerInstancesProvider.this.uiInstancesProvider.getUICallback().showErrorMessage(message, false);
            }

            @Override
            public void setScriptURL(URL url) {
            }
        });
    }

    public void readFilters() {
    }

    public ArrayFilters getArrayFilters() {
        return this.arrayFilters;
    }

    public ThreadFilters getThreadFilters() {
        return this.threadFilters;
    }

    public void loadLibrary(String libraryName) {
        try {
            System.loadLibrary(libraryName);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                URL url = this.getURL(libraryName + ".so");
                if (url == null) {
                    throw new RuntimeException(Messages.getString(ManagerInstancesProvider.class.getName() + "-8") + libraryName + "\"");
                }
                System.load(url.getPath());
            }
            catch (UnsatisfiedLinkError e2) {
                throw new RuntimeException(Messages.getString(ManagerInstancesProvider.class.getName() + "-8") + libraryName + "\"");
            }
        }
    }

    public void addAfterInitUITask(Runnable task) {
        if (this.afterInitTasksPerformed) {
            this.uiInstancesProvider.getUICallback().runUIThread(task);
        } else {
            this.afterInitUITasks.add(task);
        }
    }

    public void addAfterInitUITask(Runnable task, boolean showWaitingDialog) {
        this.addAfterInitUITask(task);
    }

    public void runAfterInitTasks() {
        this.afterInitTasksStarted = true;
        Iterator<Runnable> iterator = this.afterInitUITasks.iterator();
        while (iterator.hasNext()) {
            Runnable afterInitUITask;
            Runnable task = afterInitUITask = iterator.next();
            this.uiInstancesProvider.getUICallback().runUIThread(task);
        }
        this.afterInitTasksPerformed = true;
    }

    protected void registerVisitors() {
    }

    protected void registerScripts() {
    }

    public String getDefaultAnalysesLocation() {
        String result = System.getProperty("user.dir");
        return result != null ? result : ".";
    }

    public String getAnalysesStoreLocation() {
        String path = this.uiInstancesProvider.getConfigs().getValue(KEY_ANALYSIS_STORE_LOCATION, this.getDefaultAnalysesLocation());
        File dir = new File(path);
        if (!dir.exists()) {
            this.uiInstancesProvider.getUICallback().showError(Messages.getString(ManagerInstancesProvider.class.getName() + "-15") + path + Messages.getString(ManagerInstancesProvider.class.getName() + "-16"), false);
            path = this.getDefaultAnalysesLocation();
            this.uiInstancesProvider.getConfigs().setValue(KEY_ANALYSIS_STORE_LOCATION, path);
        }
        return path;
    }

    public HypoteticRelationsRepository getHypoteticRepository() {
        return this.hypoteticRepository;
    }

    public RelationsRepository getRelationsRepository() {
        return this.relationsRepository;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public VisitorsManager getVisitorsManager() {
        return this.visitorsManager;
    }

    public IBDDManager getBDDManager() {
        return this.bddManager;
    }

    public RelationsCache getRelationsCache() {
        return this.relationsCache;
    }

    public IRelationsManager getRelationsManager() {
        return this.relationsManager;
    }

    public AttributeQueryHistory getQueryHistory() {
        return this.queryHistory;
    }

    public RMLScript compileConsoleCommand(String command, RMLParseErrorCallback parseErrorCallback, boolean isComplex) {
        RMLScript query = new RMLScript(this.relationsManager, RMLScript.CONSOLE_QUERY, command, this.uiInstancesProvider, this.symbolTable);
        if (query.compileConsoleQuery(this.relationsRepository, parseErrorCallback, isComplex)) {
            return query;
        }
        return null;
    }

    public void runConsoleCommand(String command, RMLParseErrorCallback parseErrorCallback, ThreadCallback threadCallback, boolean isComplex) {
        RMLScript query = this.compileConsoleCommand(command, parseErrorCallback, isComplex);
        if (query != null) {
            try {
                this.scriptManager.run(query, new HashMap(), this.relationsRepository, threadCallback, this.uiInstancesProvider);
            }
            catch (Throwable e) {
                this.uiInstancesProvider.getUICallback().showException(e, false);
            }
        }
    }

    public int getMemoryState() {
        return this.bddManager.getMemoryState() + this.getSymbolTable().getMemoryState() + this.visitorsManager.getMemoryState();
    }

    public boolean isOutOfMemory() {
        return this.enableMemoryLimitWarning && this.getMemoryState() > this.memoryUsingLimit;
    }

    public void showWrongAttributeWarning(WrongAttributeException e, String source) {
        this.uiInstancesProvider.getUICallback().showError(e.getMessage() + (source != null ? Messages.getString(ManagerInstancesProvider.class.getName() + "-17") + source : ""), e, false);
    }

    public void setDomainTypeImage(String name, String icon) {
    }
}

