/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaWalker {
    JsonSchemaWalker() {
    }

    public static void findSchemasForAnnotation(@NotNull PsiElement element, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema) {
        List<Step> position = JsonSchemaWalker.findPosition(element, false);
        if (position == null || position.isEmpty()) {
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(consumer, rootSchema, false, position);
    }

    public static void findSchemasForCompletion(@NotNull PsiElement element, @NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema) {
        PsiElement checkable = JsonSchemaWalker.goUpToCheckable(element);
        if (checkable == null) {
            return;
        }
        boolean isName = JsonSchemaWalker.isName(checkable);
        List<Step> position = JsonSchemaWalker.findPosition(checkable, isName);
        if (position == null || position.isEmpty()) {
            return;
        }
        JsonSchemaWalker.extractSchemaVariants(consumer, rootSchema, isName, position);
    }

    private static void extractSchemaVariants(@NotNull CompletionSchemesConsumer consumer, @NotNull JsonSchemaObject rootSchema, boolean isName, List<Step> position) {
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        queue.add(Pair.create((Object)rootSchema, (Object)0));
        while (!queue.isEmpty()) {
            Pair pair = (Pair)queue.removeFirst();
            JsonSchemaObject schema = (JsonSchemaObject)pair.getFirst();
            final Step step = position.get((Integer)pair.getSecond());
            if (step.getTransition() == null || (Integer)pair.getSecond() == position.size() - 1) {
                consumer.consume(isName, schema);
                continue;
            }
            if (step.getTransition() != null && !step.getTransition().possibleFromState(step.getType())) continue;
            Condition<JsonSchemaObject> byTypeFilter = new Condition<JsonSchemaObject>(){

                public boolean value(JsonSchemaObject object) {
                    return JsonSchemaWalker.byStateType(step.getType(), object);
                }
            };
            if (schema.getAllOf() != null) {
                List andList = ContainerUtil.filter(schema.getAllOf(), (Condition)byTypeFilter);
                TransitionResultConsumer transitionResultConsumer = new TransitionResultConsumer();
                JsonSchemaObject selectedSchema = null;
                for (JsonSchemaObject object : andList) {
                    step.getTransition().step(object, transitionResultConsumer);
                    if (transitionResultConsumer.isNothing() || selectedSchema != null) continue;
                    selectedSchema = transitionResultConsumer.getSchema();
                }
                if (selectedSchema == null) continue;
                queue.add(Pair.create(selectedSchema, (Object)((Integer)pair.getSecond() + 1)));
                continue;
            }
            List list = new ArrayList<JsonSchemaObject>();
            list.add(schema);
            if (schema.getAnyOf() != null) {
                list.addAll(schema.getAnyOf());
            }
            if (schema.getOneOf() != null) {
                list.addAll(schema.getOneOf());
            }
            list = ContainerUtil.filter(list, (Condition)byTypeFilter);
            for (JsonSchemaObject object : list) {
                TransitionResultConsumer transitionResultConsumer = new TransitionResultConsumer();
                step.getTransition().step(object, transitionResultConsumer);
                if (transitionResultConsumer.getSchema() == null) continue;
                queue.add(Pair.create((Object)transitionResultConsumer.getSchema(), (Object)((Integer)pair.getSecond() + 1)));
            }
        }
    }

    private static boolean byStateType(@NotNull StateType type, @NotNull JsonSchemaObject schema) {
        JsonSchemaType requiredType = type.getCorrespondingJsonType();
        if (requiredType == null) {
            return true;
        }
        if (schema.getType() != null) {
            return requiredType.equals((Object)schema.getType());
        }
        if (schema.getTypeVariants() != null) {
            for (JsonSchemaType schemaType : schema.getTypeVariants()) {
                if (!requiredType.equals((Object)schemaType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isName(PsiElement checkable) {
        PsiElement parent = checkable.getParent();
        if (parent instanceof JsonObject) {
            return true;
        }
        if (parent instanceof JsonProperty) {
            return PsiTreeUtil.isAncestor((PsiElement)((JsonProperty)parent).getNameElement(), (PsiElement)checkable, (boolean)false);
        }
        return false;
    }

    @Nullable
    private static PsiElement goUpToCheckable(@NotNull PsiElement element) {
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            if (!(current instanceof JsonValue)) continue;
            return current;
        }
        return null;
    }

    public static List<Step> findPosition(@NotNull PsiElement element, boolean isName) {
        ArrayList<Step> steps = new ArrayList<Step>();
        if (!(element.getParent() instanceof JsonObject) && !isName) {
            steps.add(new Step(StateType._value, null));
        }
        PsiElement current = element;
        while (!(current instanceof PsiFile)) {
            PsiElement position = current;
            if ((current = current.getParent()) instanceof JsonArray) {
                JsonArray array = (JsonArray)current;
                List<JsonValue> list = array.getValueList();
                int idx = -1;
                for (int i = 0; i < list.size(); ++i) {
                    JsonValue value = list.get(i);
                    if (!value.equals(position)) continue;
                    idx = i;
                    break;
                }
                steps.add(new Step(StateType._array, new ArrayTransition(idx)));
                continue;
            }
            if (current instanceof JsonProperty) {
                String propertyName = ((JsonProperty)current).getName();
                if (!((current = current.getParent()) instanceof JsonObject)) {
                    return null;
                }
                steps.add(new Step(StateType._object, new PropertyTransition(propertyName)));
                continue;
            }
            if (current instanceof PsiFile) break;
            return null;
        }
        Collections.reverse(steps);
        return steps;
    }

    private static class TransitionResultConsumer {
        @Nullable
        private JsonSchemaObject mySchema;
        private boolean myAny;
        private boolean myNothing = true;

        @Nullable
        public JsonSchemaObject getSchema() {
            return this.mySchema;
        }

        public void setSchema(@Nullable JsonSchemaObject schema) {
            this.mySchema = schema;
            this.myNothing = schema == null;
        }

        public boolean isAny() {
            return this.myAny;
        }

        public void anything() {
            this.myAny = true;
            this.myNothing = false;
        }

        public boolean isNothing() {
            return this.myNothing;
        }

        public void nothing() {
            this.myNothing = true;
            this.myAny = false;
        }
    }

    private static enum StateType {
        _object(JsonSchemaType._object),
        _array(JsonSchemaType._array),
        _value(null);

        @Nullable
        private final JsonSchemaType myCorrespondingJsonType;

        private StateType(JsonSchemaType correspondingJsonType) {
            this.myCorrespondingJsonType = correspondingJsonType;
        }

        @Nullable
        public JsonSchemaType getCorrespondingJsonType() {
            return this.myCorrespondingJsonType;
        }
    }

    private static interface Transition {
        public boolean possibleFromState(@NotNull StateType var1);

        public void step(@NotNull JsonSchemaObject var1, @NotNull TransitionResultConsumer var2);
    }

    private static class ArrayTransition
    implements Transition {
        private final int myIdx;

        private ArrayTransition(int idx) {
            this.myIdx = idx;
        }

        @Override
        public boolean possibleFromState(@NotNull StateType stateType) {
            return StateType._array.equals((Object)stateType);
        }

        @Override
        public void step(@NotNull JsonSchemaObject parent, @NotNull TransitionResultConsumer resultConsumer) {
            if (parent.getItemsSchema() != null) {
                resultConsumer.setSchema(parent.getItemsSchema());
            } else if (parent.getItemsSchemaList() != null) {
                List<JsonSchemaObject> list = parent.getItemsSchemaList();
                if (this.myIdx >= 0 && this.myIdx < list.size()) {
                    resultConsumer.setSchema(list.get(this.myIdx));
                } else if (parent.getAdditionalItemsSchema() != null) {
                    resultConsumer.setSchema(parent.getAdditionalItemsSchema());
                } else if (!Boolean.FALSE.equals(parent.getAdditionalItemsAllowed())) {
                    resultConsumer.anything();
                } else {
                    resultConsumer.nothing();
                }
            }
        }
    }

    private static class PropertyTransition
    implements Transition {
        @NotNull
        private final String myName;

        private PropertyTransition(@NotNull String name) {
            this.myName = name;
        }

        @Override
        public boolean possibleFromState(@NotNull StateType stateType) {
            return StateType._object.equals((Object)stateType);
        }

        @Override
        public void step(@NotNull JsonSchemaObject parent, @NotNull TransitionResultConsumer resultConsumer) {
            JsonSchemaObject child = parent.getProperties().get(this.myName);
            if (child != null) {
                resultConsumer.setSchema(child);
            } else if (parent.getAdditionalPropertiesSchema() != null) {
                resultConsumer.setSchema(parent.getAdditionalPropertiesSchema());
            } else if (!Boolean.FALSE.equals(parent.getAdditionalPropertiesAllowed())) {
                resultConsumer.anything();
            } else {
                resultConsumer.nothing();
            }
        }
    }

    private static class Step {
        private final StateType myType;
        @Nullable
        private final Transition myTransition;

        public Step(StateType type, Transition transition) {
            this.myType = type;
            this.myTransition = transition;
        }

        public StateType getType() {
            return this.myType;
        }

        @Nullable
        public Transition getTransition() {
            return this.myTransition;
        }
    }

    public static interface CompletionSchemesConsumer {
        public void consume(boolean var1, @NotNull JsonSchemaObject var2);
    }
}

