/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.idea.RareLogger;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaImportedProviderMarker;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.CodeInsightProviders;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaObjectCodeInsightWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaServiceImpl
implements JsonSchemaService {
    private static final Logger LOGGER = Logger.getInstance(JsonSchemaServiceImpl.class);
    private static final Logger RARE_LOGGER = RareLogger.wrap(LOGGER, false);
    @Nullable
    private final Project myProject;
    private final ConcurrentMap<JsonSchemaFileProvider, JsonSchemaObjectCodeInsightWrapper> myWrappers = ContainerUtil.newConcurrentMap();

    public JsonSchemaServiceImpl(@Nullable Project project2) {
        this.myProject = project2;
        if (project2 != null) {
            ApplicationManager.getApplication().getMessageBus().connect((Disposable)project2).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new JsonSchemaVfsListener(project2, this));
        }
    }

    @NotNull
    protected JsonSchemaProviderFactory[] getProviderFactories() {
        return (JsonSchemaProviderFactory[])JsonSchemaProviderFactory.EP_NAME.getExtensions();
    }

    @Override
    @Nullable
    public Annotator getAnnotator(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getAnnotator() : null;
    }

    @Override
    @Nullable
    public CompletionContributor getCompletionContributor(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getContributor() : null;
    }

    @Override
    public boolean hasSchema(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null;
    }

    @Override
    @Nullable
    public DocumentationProvider getDocumentationProvider(@Nullable VirtualFile file2) {
        CodeInsightProviders wrapper = this.getWrapper(file2);
        return wrapper != null ? wrapper.getDocumentationProvider() : null;
    }

    @Override
    @Nullable
    public List<Pair<Boolean, String>> getMatchingSchemaDescriptors(@Nullable VirtualFile file2) {
        List<JsonSchemaObjectCodeInsightWrapper> wrappers = this.getWrappers(file2);
        if (wrappers == null || wrappers.isEmpty()) {
            return null;
        }
        return ContainerUtil.map(wrappers, (Function)new NotNullFunction<JsonSchemaObjectCodeInsightWrapper, Pair<Boolean, String>>(){

            @NotNull
            public Pair<Boolean, String> fun(JsonSchemaObjectCodeInsightWrapper wrapper) {
                return Pair.create((Object)wrapper.isUserSchema(), (Object)wrapper.getName());
            }
        });
    }

    @Nullable
    private static JsonSchemaObjectCodeInsightWrapper createWrapper(@NotNull JsonSchemaFileProvider provider) {
        Reader reader = provider.getSchemaReader();
        try {
            if (reader != null) {
                JsonSchemaObject resultObject = new JsonSchemaReader().read(reader);
                return new JsonSchemaObjectCodeInsightWrapper(provider.getName(), resultObject).setUserSchema(provider instanceof JsonSchemaImportedProviderMarker);
            }
        }
        catch (Exception e) {
            String message = "Error while processing json schema file: " + e.getMessage();
            if (provider instanceof JsonSchemaImportedProviderMarker) {
                RARE_LOGGER.info(message, (Throwable)e);
            }
            LOGGER.error(message, (Throwable)e);
        }
        return null;
    }

    @Override
    public void reset() {
        this.myWrappers.clear();
    }

    @Nullable
    private CodeInsightProviders getWrapper(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileType type = file2.getFileType();
        if (type instanceof LanguageFileType && ((LanguageFileType)type).getLanguage().isKindOf((Language)JsonLanguage.INSTANCE)) {
            List<JsonSchemaObjectCodeInsightWrapper> wrappers = this.getWrappers(file2);
            if (wrappers == null || wrappers.isEmpty()) {
                return null;
            }
            return wrappers.size() == 1 ? (CodeInsightProviders)wrappers.get(0) : new CompositeCodeInsightProviderWithWarning(wrappers);
        }
        return null;
    }

    @Nullable
    private List<JsonSchemaObjectCodeInsightWrapper> getWrappers(@Nullable VirtualFile file2) {
        JsonSchemaProviderFactory[] factories;
        if (file2 == null) {
            return null;
        }
        ArrayList<JsonSchemaObjectCodeInsightWrapper> wrappers = new ArrayList<JsonSchemaObjectCodeInsightWrapper>();
        for (JsonSchemaProviderFactory factory : factories = this.getProviderFactories()) {
            for (JsonSchemaFileProvider provider : factory.getProviders(this.myProject)) {
                if (!provider.isAvailable(file2)) continue;
                JsonSchemaObjectCodeInsightWrapper wrapper = (JsonSchemaObjectCodeInsightWrapper)this.myWrappers.get(provider);
                if (wrapper == null) {
                    JsonSchemaObjectCodeInsightWrapper newWrapper = JsonSchemaServiceImpl.createWrapper(provider);
                    if (newWrapper == null) {
                        return null;
                    }
                    this.myWrappers.putIfAbsent(provider, newWrapper);
                    wrapper = (JsonSchemaObjectCodeInsightWrapper)this.myWrappers.get(provider);
                }
                if (wrapper == null) continue;
                wrappers.add(wrapper);
            }
        }
        return wrappers;
    }

    private static class CompositeCodeInsightProviderWithWarning
    implements CodeInsightProviders {
        private final List<JsonSchemaObjectCodeInsightWrapper> myWrappers;
        private CompletionContributor myContributor;
        private Annotator myAnnotator;
        private DocumentationProvider myDocumentationProvider;

        public CompositeCodeInsightProviderWithWarning(List<JsonSchemaObjectCodeInsightWrapper> wrappers) {
            List<Object> userSchemaWrappers = ContainerUtil.filter(wrappers, (Condition)new Condition<JsonSchemaObjectCodeInsightWrapper>(){

                public boolean value(JsonSchemaObjectCodeInsightWrapper wrapper) {
                    return wrapper.isUserSchema();
                }
            });
            this.myWrappers = !userSchemaWrappers.isEmpty() && userSchemaWrappers.size() + 1 == wrappers.size() ? userSchemaWrappers : wrappers;
            this.myContributor = new CompletionContributor(){

                public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
                    for (JsonSchemaObjectCodeInsightWrapper wrapper : myWrappers) {
                        wrapper.getContributor().fillCompletionVariants(parameters, result);
                    }
                }
            };
            this.myAnnotator = new Annotator(){

                public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
                    for (JsonSchemaObjectCodeInsightWrapper wrapper : myWrappers) {
                        wrapper.getAnnotator().annotate(element, holder);
                    }
                }
            };
            ArrayList<DocumentationProvider> list = new ArrayList<DocumentationProvider>();
            for (JsonSchemaObjectCodeInsightWrapper wrapper : this.myWrappers) {
                list.add(wrapper.getDocumentationProvider());
            }
            this.myDocumentationProvider = CompositeDocumentationProvider.wrapProviders(list);
        }

        @Override
        @NotNull
        public CompletionContributor getContributor() {
            return this.myContributor;
        }

        @Override
        @NotNull
        public Annotator getAnnotator() {
            return this.myAnnotator;
        }

        @Override
        @NotNull
        public DocumentationProvider getDocumentationProvider() {
            return this.myDocumentationProvider;
        }
    }
}

