/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.documentation.DocumentationProvider;
import com.jetbrains.jsonSchema.impl.CodeInsightProviders;
import com.jetbrains.jsonSchema.impl.JsonBySchemaDocumentationProvider;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectAnnotator;
import com.jetbrains.jsonSchema.impl.JsonBySchemaObjectCompletionContributor;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import org.jetbrains.annotations.NotNull;

class JsonSchemaObjectCodeInsightWrapper
implements CodeInsightProviders {
    @NotNull
    private final String myName;
    private boolean myIsUserSchema;
    @NotNull
    private final CompletionContributor myContributor;
    @NotNull
    private final Annotator myAnnotator;
    @NotNull
    private final DocumentationProvider myDocumentationProvider;

    public JsonSchemaObjectCodeInsightWrapper(@NotNull String name, @NotNull JsonSchemaObject schemaObject) {
        this.myName = name;
        this.myContributor = new JsonBySchemaObjectCompletionContributor(schemaObject);
        this.myAnnotator = new JsonBySchemaObjectAnnotator(schemaObject);
        this.myDocumentationProvider = new JsonBySchemaDocumentationProvider(schemaObject);
    }

    @Override
    @NotNull
    public CompletionContributor getContributor() {
        return this.myContributor;
    }

    @Override
    @NotNull
    public Annotator getAnnotator() {
        return this.myAnnotator;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public DocumentationProvider getDocumentationProvider() {
        return this.myDocumentationProvider;
    }

    public JsonSchemaObjectCodeInsightWrapper setUserSchema(boolean userSchema) {
        this.myIsUserSchema = userSchema;
        return this;
    }

    public boolean isUserSchema() {
        return this.myIsUserSchema;
    }
}

