/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.DataManager;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaPropertyProcessor;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonBySchemaObjectCompletionContributor
extends CompletionContributor {
    @NotNull
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaObjectCompletionContributor(@NotNull JsonSchemaObject rootSchema) {
        this.myRootSchema = rootSchema;
    }

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        PsiElement position = parameters.getPosition();
        PsiFile containingFile = position.getContainingFile();
        if (containingFile == null) {
            return;
        }
        new Worker(this.myRootSchema, position, (Consumer<LookupElement>)result).work();
        result.stopHere();
    }

    public static List<LookupElement> getCompletionVariants(@NotNull JsonSchemaObject schema, @NotNull PsiElement position) {
        final ArrayList<LookupElement> result = new ArrayList<LookupElement>();
        new Worker(schema, position, new Consumer<LookupElement>(){

            public void consume(LookupElement element) {
                result.add(element);
            }
        }).work();
        return result;
    }

    public static void insertStringPropertyWithEnum(InsertionContext context, Editor editor, String defaultValue, List<Object> values) {
        String start = ":\"";
        String end = "\"";
        boolean hasValues = !ContainerUtil.isEmpty(values);
        boolean hasDefaultValue = !StringUtil.isEmpty((String)defaultValue);
        String stringToInsert = start + (hasDefaultValue ? defaultValue : "") + end;
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
        if (hasDefaultValue) {
            SelectionModel model = editor.getSelectionModel();
            int caretStart = model.getSelectionStart();
            int newOffset = caretStart + defaultValue.length();
            model.setSelection(caretStart, newOffset);
            editor.getCaretModel().moveToOffset(newOffset);
        }
        JsonBySchemaObjectCompletionContributor.formatInsertedString(context, context.getProject(), stringToInsert.length());
        if (hasValues) {
            AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        }
    }

    public static void formatInsertedString(InsertionContext context, Project project2, int offset) {
        PsiDocumentManager.getInstance((Project)project2).commitDocument(context.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        codeStyleManager.reformatText(context.getFile(), context.getStartOffset(), context.getTailOffset() + offset);
    }

    private static class Worker {
        @NotNull
        private final JsonSchemaObject myRootSchema;
        @NotNull
        private final PsiElement myPosition;
        @NotNull
        private final Consumer<LookupElement> myResultConsumer;
        private final boolean myInsideStringLiteral;
        private final List<LookupElement> myVariants;

        public Worker(@NotNull JsonSchemaObject rootSchema, @NotNull PsiElement position, @NotNull Consumer<LookupElement> resultConsumer) {
            this.myRootSchema = rootSchema;
            this.myPosition = position;
            this.myResultConsumer = resultConsumer;
            this.myInsideStringLiteral = position.getParent() instanceof JsonStringLiteral;
            this.myVariants = new ArrayList<LookupElement>();
        }

        public void work() {
            JsonSchemaWalker.findSchemasForCompletion(this.myPosition, new JsonSchemaWalker.CompletionSchemesConsumer(){

                @Override
                public void consume(boolean isName, @NotNull JsonSchemaObject schema) {
                    if (isName) {
                        PsiElement possibleParent = myPosition.getParent().getParent();
                        JsonProperty parent = possibleParent instanceof JsonProperty ? (JsonProperty)possibleParent : null;
                        final boolean hasValue = this.hasValuePart(parent);
                        final Collection<String> properties = this.getExistingProperties(parent);
                        JsonSchemaPropertyProcessor.process(new JsonSchemaPropertyProcessor.PropertyProcessor(){

                            @Override
                            public boolean process(String name, JsonSchemaObject schema) {
                                if (properties.contains(name)) {
                                    return true;
                                }
                                this.addPropertyVariant(name, schema, hasValue);
                                return true;
                            }
                        }, schema);
                    } else {
                        this.suggestValues(schema);
                    }
                }
            }, this.myRootSchema);
            for (LookupElement variant : this.myVariants) {
                this.myResultConsumer.consume((Object)variant);
            }
        }

        public Collection<String> getExistingProperties(@Nullable JsonProperty property) {
            if (property == null) {
                return ContainerUtil.emptyList();
            }
            PsiElement parent = property.getParent();
            if (!(parent instanceof JsonObject)) {
                return ContainerUtil.emptyList();
            }
            JsonObject object = (JsonObject)parent;
            HashSet result = ContainerUtil.newHashSet();
            for (JsonProperty jsonProperty : object.getPropertyList()) {
                if (jsonProperty == property) continue;
                result.add(jsonProperty.getName());
            }
            return result;
        }

        public boolean hasValuePart(@Nullable JsonProperty property) {
            if (property != null && this.myInsideStringLiteral) {
                return property.getValue() != null;
            }
            return true;
        }

        private void suggestValues(JsonSchemaObject schema) {
            this.suggestValuesForSchemaVariants(schema.getAnyOf());
            this.suggestValuesForSchemaVariants(schema.getOneOf());
            this.suggestValuesForSchemaVariants(schema.getAllOf());
            if (schema.getEnum() != null) {
                for (Object o : schema.getEnum()) {
                    this.addValueVariant(o.toString(), null);
                }
            } else {
                JsonSchemaType type = schema.getType();
                if (JsonSchemaType._boolean.equals((Object)type)) {
                    this.addPossibleBooleanValue(type);
                    List<JsonSchemaType> variants = schema.getTypeVariants();
                    if (variants != null) {
                        for (JsonSchemaType variant : variants) {
                            this.addPossibleBooleanValue(variant);
                        }
                    }
                } else if (JsonSchemaType._string.equals((Object)type)) {
                    this.addPossibleStringValue(schema);
                }
            }
        }

        private void addPossibleStringValue(JsonSchemaObject schema) {
            String defaultValueString;
            Object defaultValue = schema.getDefault();
            String string = defaultValueString = defaultValue == null ? null : defaultValue.toString();
            if (!StringUtil.isEmpty((String)defaultValueString)) {
                String quotedValue = defaultValueString;
                if (!StringUtil.isQuotedString((String)quotedValue)) {
                    quotedValue = StringUtil.wrapWithDoubleQuote((String)quotedValue);
                }
                this.addValueVariant(quotedValue, null);
            }
        }

        private void suggestValuesForSchemaVariants(List<JsonSchemaObject> list) {
            if (list != null && list.size() > 0) {
                for (JsonSchemaObject schemaObject : list) {
                    this.suggestValues(schemaObject);
                }
            }
        }

        private void addPossibleBooleanValue(JsonSchemaType type) {
            if (JsonSchemaType._boolean.equals((Object)type)) {
                this.addValueVariant("true", null);
                this.addValueVariant("false", null);
            }
        }

        private void addValueVariant(@NotNull String key, @Nullable String description) {
            LookupElementBuilder builder = LookupElementBuilder.create((String)(this.myInsideStringLiteral ? StringUtil.unquoteString((String)key) : key));
            if (description != null) {
                builder = builder.withTypeText(description);
            }
            this.myVariants.add((LookupElement)builder);
        }

        private void addPropertyVariant(@NotNull String key, @NotNull JsonSchemaObject jsonSchemaObject, boolean hasValue) {
            String typeText;
            String description = jsonSchemaObject.getDescription();
            String title = jsonSchemaObject.getTitle();
            key = this.myInsideStringLiteral ? key : StringUtil.wrapWithDoubleQuote((String)key);
            LookupElementBuilder builder = LookupElementBuilder.create((String)key);
            String string = typeText = StringUtil.isEmpty((String)title) ? description : title;
            if (!StringUtil.isEmpty((String)typeText)) {
                builder = builder.withTypeText(typeText, true);
            }
            JsonSchemaType type = jsonSchemaObject.getType();
            List<Object> values = jsonSchemaObject.getEnum();
            if (type != null || !ContainerUtil.isEmpty(values)) {
                builder = builder.withInsertHandler(this.createPropertyInsertHandler(jsonSchemaObject, hasValue));
            }
            this.myVariants.add((LookupElement)builder);
        }

        @NotNull
        private InsertHandler<LookupElement> createPropertyInsertHandler(@NotNull JsonSchemaObject jsonSchemaObject, final boolean hasValue) {
            final JsonSchemaType type = jsonSchemaObject.getType();
            final List<Object> values = jsonSchemaObject.getEnum();
            Object defaultValue = jsonSchemaObject.getDefault();
            final String defaultValueAsString = defaultValue == null ? null : String.valueOf(defaultValue);
            return new InsertHandler<LookupElement>(){

                public void handleInsert(InsertionContext context, LookupElement item) {
                    ApplicationManager.getApplication().assertWriteAccessAllowed();
                    Editor editor = context.getEditor();
                    Project project2 = context.getProject();
                    if (myInsideStringLiteral) {
                        int endOffset;
                        int offset = editor.getCaretModel().getOffset();
                        PsiElement element = context.getFile().findElementAt(offset);
                        int tailOffset = context.getTailOffset();
                        int guessEndOffset = tailOffset + 1;
                        if (element != null && (endOffset = element.getTextRange().getEndOffset()) > tailOffset) {
                            context.getDocument().deleteString(tailOffset, endOffset - 1);
                        }
                        if (hasValue) {
                            return;
                        }
                        editor.getCaretModel().moveToOffset(guessEndOffset);
                    }
                    if (type != null) {
                        switch (type) {
                            case _object: {
                                String stringToInsert = ":{}";
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                PsiDocumentManager.getInstance((Project)project2).commitDocument(editor.getDocument());
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context, project2, stringToInsert.length());
                                EditorActionHandler handler2 = EditorActionManager.getInstance().getActionHandler("EditorEnter");
                                handler2.execute(editor, editor.getCaretModel().getCurrentCaret(), DataManager.getInstance().getDataContext((Component)editor.getContentComponent()));
                                break;
                            }
                            case _boolean: {
                                String value = String.valueOf(Boolean.TRUE.toString().equals(defaultValueAsString));
                                String stringToInsert = ":" + value;
                                SelectionModel model = editor.getSelectionModel();
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)stringToInsert.length());
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context, context.getProject(), stringToInsert.length());
                                int start = editor.getSelectionModel().getSelectionStart();
                                model.setSelection(start - value.length(), start);
                                AutoPopupController.getInstance(context.getProject()).autoPopupMemberLookup(context.getEditor(), null);
                                break;
                            }
                            case _array: {
                                String stringToInsert = ":[]";
                                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)stringToInsert, (boolean)false, (boolean)true, (int)2);
                                JsonBySchemaObjectCompletionContributor.formatInsertedString(context, project2, stringToInsert.length());
                                break;
                            }
                            case _string: {
                                JsonBySchemaObjectCompletionContributor.insertStringPropertyWithEnum(context, editor, defaultValueAsString, values);
                                break;
                            }
                        }
                    } else {
                        JsonBySchemaObjectCompletionContributor.insertStringPropertyWithEnum(context, editor, defaultValueAsString, values);
                    }
                }
            };
        }
    }
}

