/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaPropertyProcessor;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonBySchemaDocumentationProvider
implements DocumentationProvider {
    @NotNull
    private final JsonSchemaObject myRootSchema;

    public JsonBySchemaDocumentationProvider(@NotNull JsonSchemaObject schema) {
        this.myRootSchema = schema;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (element instanceof JsonProperty) {
            final Ref result = Ref.create();
            JsonProperty jsonProperty = (JsonProperty)element;
            final String propertyName = jsonProperty.getName();
            JsonSchemaWalker.findSchemasForCompletion(jsonProperty, new JsonSchemaWalker.CompletionSchemesConsumer(){

                @Override
                public void consume(boolean isName, @NotNull JsonSchemaObject schema) {
                    JsonSchemaPropertyProcessor.process(new JsonSchemaPropertyProcessor.PropertyProcessor(){

                        @Override
                        public boolean process(String name, JsonSchemaObject schema) {
                            if (propertyName.equals(name) && schema != null) {
                                result.set((Object)schema.getDescription());
                                return false;
                            }
                            return true;
                        }
                    }, schema);
                }
            }, this.myRootSchema);
            return (String)result.get();
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }
}

