/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.jetbrains.jsonSchema.JsonSchemaMappingsProjectConfiguration;
import com.jetbrains.jsonSchema.impl.JsonSchemaServiceImpl;
import org.jetbrains.annotations.NotNull;

public class JsonSchemaVfsListener
extends BulkVirtualFileListenerAdapter {
    public JsonSchemaVfsListener(final Project project2, final @NotNull JsonSchemaServiceImpl service) {
        super((VirtualFileListener)new VirtualFileAdapter(){
            @NotNull
            private final JsonSchemaServiceImpl myService;
            private JsonSchemaMappingsProjectConfiguration myMappingsProjectConfiguration;
            {
                this.myService = service;
                this.myMappingsProjectConfiguration = JsonSchemaMappingsProjectConfiguration.getInstance(project2);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                this.onFileChange(event.getFile());
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                this.onFileChange(event.getFile());
            }

            public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
                this.onFileChange(event.getFile());
            }

            public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
                this.onFileChange(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                this.onFileChange(event.getFile());
            }

            public void fileCopied(@NotNull VirtualFileCopyEvent event) {
                this.onFileChange(event.getFile());
            }

            private void onFileChange(@NotNull VirtualFile file2) {
                if (this.myMappingsProjectConfiguration.isRegisteredSchemaFile(file2)) {
                    this.myService.reset();
                }
            }
        });
    }
}

