/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.javascript.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.jetbrains.javascript.debugger.ExpressionInfoFactory;
import com.jetbrains.javascript.debugger.NameMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilter;

public abstract class JavaScriptDebugAware {
    public static final ExtensionPointName<JavaScriptDebugAware> EP_NAME = ExtensionPointName.create((String)"com.jetbrains.javaScriptDebugAware");

    @Nullable
    protected LanguageFileType getFileType() {
        return null;
    }

    @Nullable
    public Class<? extends XLineBreakpointType<?>> getBreakpointTypeClass() {
        return null;
    }

    public boolean isOnlySourceMappedBreakpoints() {
        return true;
    }

    public final boolean canGetEvaluationInfo(@NotNull PsiFile file2) {
        return file2.getFileType().equals(this.getFileType());
    }

    @Nullable
    public final ExpressionInfo getEvaluationInfo(@NotNull PsiFile file2, int offset, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        PsiElement element = file2.findElementAt(offset);
        return element == null ? null : this.getEvaluationInfo(element, document, expressionInfoFactory);
    }

    @Nullable
    protected ExpressionInfo getEvaluationInfo(@NotNull PsiElement elementAtOffset, @NotNull Document document, @NotNull ExpressionInfoFactory expressionInfoFactory) {
        return null;
    }

    public static boolean isBreakpointAware(@NotNull FileType fileType) {
        JavaScriptDebugAware aware = JavaScriptDebugAware.getBreakpointAware(fileType);
        return aware != null && aware.getBreakpointTypeClass() == null;
    }

    @Nullable
    public static JavaScriptDebugAware getBreakpointAware(@NotNull FileType fileType) {
        for (JavaScriptDebugAware debugAware : (JavaScriptDebugAware[])EP_NAME.getExtensions()) {
            if (!fileType.equals(debugAware.getFileType())) continue;
            return debugAware;
        }
        return null;
    }

    @Nullable
    public MemberFilter createMemberFilter(@Nullable NameMapper nameMapper, @NotNull PsiElement element, int end) {
        return null;
    }

    @Nullable
    public PsiElement getNavigationElementForSourcemapInspector(@NotNull PsiFile file2) {
        return null;
    }

    @Nullable
    public String normalizeMemberName(@NotNull String name) {
        return null;
    }
}

