/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.terms;

import com.jetbrains.gsa.terms.Term;
import com.jetbrains.gsa.terms.Terms;
import com.jetbrains.gsa.text.WriteString;

public class StartTables {
    static final int MAX_TERMS = 1024;
    static StartTable[] store = new StartTable[1024];
    public static int numOfTables = 0;

    public static WriteString writeTables() {
        WriteString ans = new WriteString();
        ans.appendf("private boolean start [] [];\n");
        ans.appendf("private static int startRLE [] [] = {");
        for (int i = 0; i < numOfTables; ++i) {
            ans.appendf("\n{ " + (StartTables.store[i].table[0] ? "1" : "0"));
            boolean last = StartTables.store[i].table[0];
            int lastStart = 0;
            for (int j = 1; j < Terms.numElems; ++j) {
                if (StartTables.store[i].table[j] == last) continue;
                ans.appendf(", " + (j - lastStart));
                last = !last;
                lastStart = j;
            }
            ans.appendf(", " + (Terms.numElems - lastStart) + " }");
            if (i >= numOfTables - 1) continue;
            ans.appendf(",");
        }
        ans.appendf("\n};\n\n");
        return ans;
    }

    public static class StartTable {
        public boolean[] table = new boolean[1024];
        public boolean first;
        public int oneTerm = -1;
        private int number = -1;
        public static final int undefined = -1;

        public StartTable() {
            for (int i = 0; i < 1024; ++i) {
                this.table[i] = false;
            }
            this.number = -1;
            this.first = true;
        }

        public int getNumber() {
            if (this.number == -1) {
                for (int i = 0; i < numOfTables; ++i) {
                    if (!this.equalsTo(store[i])) continue;
                    return i;
                }
                StartTables.store[StartTables.numOfTables] = this;
                return numOfTables++;
            }
            return this.number;
        }

        private boolean equalsTo(StartTable table) {
            for (int i = 0; i < Terms.numElems; ++i) {
                if (this.table[i] == table.table[i]) continue;
                return false;
            }
            return true;
        }

        public boolean transparent() {
            return this.table[Terms.emptyWord.number];
        }

        public void include(Term term) {
            this.table[term.number] = true;
        }

        public void exclude(Term term) {
            this.table[term.number] = false;
        }

        public int merge(StartTable table) {
            int flag = -1;
            for (int i = 0; i < Terms.numElems; ++i) {
                if (this.table[i] && table.table[i]) {
                    flag = i;
                }
                int n = i;
                this.table[n] = this.table[n] | table.table[i];
            }
            return flag;
        }

        public boolean hasOneTerm() {
            int oneTerm = -1;
            int numOfTerms = 0;
            for (int i = 0; i < Terms.numElems; ++i) {
                if (!this.table[i] || i == Terms.emptyWord.number) continue;
                ++numOfTerms;
                oneTerm = i;
            }
            if (numOfTerms == 1) {
                this.oneTerm = oneTerm;
            }
            return numOfTerms == 1;
        }
    }
}

