/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointPropertiesPanel;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.ui.OCSymbolTextFieldCompletionProvider;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSymbolicBreakpointPropertiesPanel
extends CidrSymbolicBreakpointPropertiesPanel {
    private static final Pattern OBJC_METHOD_PATTERN = Pattern.compile("[-+]?(\\[(\\w*)( ([\\w:]*))?]?)");

    public OCSymbolicBreakpointPropertiesPanel(@NotNull Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    protected TextFieldWithAutoCompletion createSymbolNameField() {
        return new OCTextFieldWithSymbolAutoCompletion(this.myProject, new ClassSymbolsProvider(this.myProject));
    }

    private static class OCClassLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private OCClassLookupElementInsertHandler() {
            super(' ');
        }

        @Override
        public void handleInsert(InsertionContext c, LookupElement item) {
            CharSequence sequence = c.getDocument().getCharsSequence();
            if (c.getStartOffset() == 0 || sequence.length() > 0 && sequence.charAt(c.getStartOffset() - 1) != '[') {
                c.getDocument().insertString(c.getStartOffset(), (CharSequence)String.valueOf('['));
            }
            super.handleInsert(c, item);
            OCClassLookupElementInsertHandler.reInvokeCompletion(c);
        }
    }

    private static class LookupElementInsertHandler
    implements InsertHandler<LookupElement> {
        private final char myChar;
        private final Condition<InsertionContext> myCondition;

        private LookupElementInsertHandler() {
            this(' ');
        }

        private LookupElementInsertHandler(char aChar) {
            this(aChar, (Condition<InsertionContext>)null);
        }

        private LookupElementInsertHandler(char aChar, @Nullable Condition<InsertionContext> condition) {
            this.myChar = aChar;
            this.myCondition = condition;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            CharSequence text;
            int offset;
            if (context.getCompletionChar() != this.myChar && (this.myCondition == null || this.myCondition.value((Object)context)) && (offset = context.getTailOffset()) == (text = context.getDocument().getCharsSequence()).length()) {
                LookupElementInsertHandler.addCompletionString(context, offset, String.valueOf(this.myChar));
            }
        }

        protected static void addCompletionString(@NotNull InsertionContext context, int offset, @NotNull String string) {
            context.getDocument().insertString(offset, (CharSequence)string);
            context.getEditor().getCaretModel().moveCaretRelatively(string.length(), 0, false, false, true);
        }

        protected static void reInvokeCompletion(final @NotNull InsertionContext context) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    new CodeCompletionHandlerBase(CompletionType.BASIC).invokeCompletion(context.getProject(), context.getEditor());
                }
            });
        }
    }

    private static class CppLookupElementInsertHandler
    extends LookupElementInsertHandler {
        private CppLookupElementInsertHandler() {
        }

        @Override
        public void handleInsert(InsertionContext context, LookupElement item) {
            if (item.getObject() instanceof OCSymbolWithQualifiedName) {
                OCSymbolWithQualifiedName symbol = (OCSymbolWithQualifiedName)item.getObject();
                OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName(new OCResolveContext(symbol.getContainingOCFile()));
                if (qualifiedName != null) {
                    String text = qualifiedName.getCanonicalName(true);
                    if (symbol instanceof OCFunctionSymbol) {
                        text = text + "(" + StringUtil.join((Collection)ContainerUtil.map(((OCFunctionSymbol)symbol).getParameterSymbols(), (Function)new Function<OCDeclaratorSymbol, String>(){

                            public String fun(OCDeclaratorSymbol symbol) {
                                String canonicalName = symbol.getResolvedType().getCanonicalName();
                                canonicalName = StringUtil.trimStart((String)canonicalName, (String)"::");
                                canonicalName = canonicalName.replace(" *", "*");
                                return canonicalName;
                            }
                        }), (String)", ") + ")";
                        if (symbol.isConst()) {
                            text = text + " const";
                        }
                    }
                    context.getDocument().replaceString(0, context.getTailOffset(), (CharSequence)text.substring(2));
                }
                if (!(item.getObject() instanceof OCFunctionSymbol)) {
                    CppLookupElementInsertHandler.addCompletionString(context, context.getDocument().getTextLength(), "::");
                    CppLookupElementInsertHandler.reInvokeCompletion(context);
                }
            }
        }
    }

    private static class ClassSymbolsProvider
    extends OCSymbolTextFieldCompletionProvider {
        @NotNull
        private final Project myProject;

        private ClassSymbolsProvider(@NotNull Project project2) {
            super(new Function<OCSymbol, String>(){

                public String fun(OCSymbol symbol) {
                    if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getResolvedOwner() != null) {
                        return ((OCFunctionSymbol)symbol).getSignatureWithoutParamNames(true, false);
                    }
                    return symbol.getPresentableName();
                }
            });
            this.myProject = project2;
        }

        @Override
        @NotNull
        public Collection<OCSymbol> getItems(String prefix, boolean cached, CompletionParameters parameters) {
            Collection<OCSymbol> items;
            String text = parameters.getOriginalFile().getText();
            if (cached || prefix == null || text.isEmpty()) {
                return Collections.emptyList();
            }
            Matcher m = OBJC_METHOD_PATTERN.matcher(text);
            if (m.matches()) {
                items = m.group(4) != null ? this.collectMethodsForClass(m.group(2)) : this.collectAllClasses();
            } else {
                PrefixMatcher prefixMatcher = this.createPrefixMatcher(prefix);
                items = this.collectFunctions(text, prefixMatcher);
                if (!text.contains("::")) {
                    items.addAll(this.collectMatchingMethods(prefixMatcher));
                    items.addAll(this.collectAllClasses());
                }
            }
            ArrayList<OCSymbol> list = new ArrayList<OCSymbol>(items);
            Collections.sort(list, this);
            return list;
        }

        private Collection<OCSymbol> collectMethodsForClass(@Nullable String className) {
            final HashSet set = new HashSet();
            CommonProcessors.CollectProcessor<OCSymbol> methodSymbolCollector = new CommonProcessors.CollectProcessor<OCSymbol>(){

                public boolean accept(OCSymbol method) {
                    return set.add(method.getPresentableName());
                }
            };
            Processor<OCSymbol> processor2 = new Processor<OCSymbol>((CommonProcessors.CollectProcessor)methodSymbolCollector){
                final /* synthetic */ CommonProcessors.CollectProcessor val$methodSymbolCollector;
                {
                    this.val$methodSymbolCollector = collectProcessor;
                }

                public boolean process(OCSymbol symbol) {
                    if (symbol instanceof OCClassSymbol) {
                        ((OCClassSymbol)symbol).processMembersInAllCategories((String)null, OCMethodSymbol.class, this.val$methodSymbolCollector);
                        for (String protocolName : ((OCClassSymbol)symbol).getProtocolNames()) {
                            if (protocolName.equals(symbol.getName())) continue;
                            OCGlobalProjectSymbolsCache.processTopLevelSymbols(myProject, this, protocolName);
                        }
                    }
                    return true;
                }
            };
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(this.myProject, processor2, className);
            return methodSymbolCollector.getResults();
        }

        private Collection<OCSymbol> collectAllClasses() {
            return this.collectSymbols(this.myProject, true, new Condition<OCSymbol>(){

                public boolean value(OCSymbol symbol) {
                    return (symbol instanceof OCImplementationSymbol || symbol instanceof OCInterfaceSymbol) && ((OCClassSymbol)symbol).getCategoryName() == null;
                }
            });
        }

        private Collection<OCSymbol> collectFunctions(final @NotNull String text, final @NotNull PrefixMatcher prefixMatcher) {
            final HashSet set = new HashSet();
            String[] strings = text.split("::", -1);
            final String parentName = strings.length >= 2 ? strings[strings.length - 2] : null;
            CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    OCQualifiedName qualifiedName;
                    String nameWithParent;
                    if ((symbol instanceof OCFunctionSymbol || ClassSymbolsProvider.isValidNamespace(symbol)) && prefixMatcher.prefixMatches(nameWithParent = ((OCSymbolWithQualifiedName)symbol).getNameWithParent()) && (qualifiedName = ((OCSymbolWithQualifiedName)symbol).getResolvedQualifiedName()) != null) {
                        String canonicalName = qualifiedName.getCanonicalName(true);
                        return this.createPrefixMatcher(text).prefixMatches(canonicalName) && set.add(canonicalName);
                    }
                    return false;
                }
            };
            new ReadAction<OCQualifiedName>((CommonProcessors.CollectProcessor)processor2){
                final /* synthetic */ CommonProcessors.CollectProcessor val$processor;
                {
                    this.val$processor = collectProcessor;
                }

                protected void run(@NotNull Result<OCQualifiedName> result) throws Throwable {
                    boolean topLevelOnly = false;
                    if (parentName != null) {
                        if (parentName.isEmpty()) {
                            topLevelOnly = true;
                        } else {
                            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(myProject, new Processor<OCSymbol>(){

                                public boolean process(OCSymbol symbol) {
                                    if (symbol instanceof OCNamespaceSymbol) {
                                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)val$processor);
                                    }
                                    return true;
                                }
                            }, parentName);
                        }
                    }
                    if (this.val$processor.getResults().isEmpty()) {
                        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(myProject, (Processor<OCSymbol>)this.val$processor, null, topLevelOnly);
                    }
                }
            }.execute();
            return processor2.getResults();
        }

        private static boolean isValidNamespace(OCSymbol symbol) {
            boolean validNamespace;
            boolean bl = validNamespace = symbol instanceof OCNamespaceSymbol && symbol.getKind() != OCSymbolKind.ENUM;
            if (validNamespace) {
                CommonProcessors.FindFirstProcessor<OCSymbol> findFirstProcessor = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                    protected boolean accept(OCSymbol symbol) {
                        return symbol instanceof OCFunctionSymbol || symbol instanceof OCNamespaceSymbol;
                    }
                };
                ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)findFirstProcessor);
                validNamespace = findFirstProcessor.isFound();
            }
            return validNamespace;
        }

        private Collection<OCSymbol> collectMatchingMethods(final PrefixMatcher prefixMatcher) {
            final HashSet set = new HashSet();
            CommonProcessors.CollectProcessor<OCSymbol> objCProcessor = new CommonProcessors.CollectProcessor<OCSymbol>(){

                protected boolean accept(OCSymbol symbol) {
                    return symbol instanceof OCMethodSymbol && prefixMatcher.prefixMatches(symbol.getPresentableName()) && set.add(symbol.getPresentableName());
                }
            };
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(this.myProject, (Processor<OCSymbol>)objCProcessor, null);
            return objCProcessor.getResults();
        }

        @Override
        @Nullable
        protected InsertHandler<LookupElement> createInsertHandler(@NotNull OCSymbol item) {
            if (item instanceof OCMethodSymbol) {
                return new LookupElementInsertHandler(']', (Condition)new Condition<InsertionContext>(){

                    public boolean value(InsertionContext c) {
                        return c.getDocument().getText(TextRange.create((int)0, (int)c.getTailOffset())).contains("[");
                    }
                });
            }
            if (item instanceof OCNamespaceSymbol || item instanceof OCFunctionSymbol) {
                return new CppLookupElementInsertHandler();
            }
            if (item instanceof OCClassSymbol) {
                return new OCClassLookupElementInsertHandler();
            }
            return new LookupElementInsertHandler(' ');
        }

        @Override
        @Nullable
        public String getPrefix(@NotNull CompletionParameters parameters) {
            String text = parameters.getOriginalFile().getText();
            Matcher m = OBJC_METHOD_PATTERN.matcher(text);
            if (m.matches()) {
                int offset = parameters.getOffset();
                String prefix = ClassSymbolsProvider.getCurrentToken(text, m, offset, 4);
                if (prefix != null) {
                    return prefix;
                }
                return ClassSymbolsProvider.getCurrentToken(text, m, offset, 2);
            }
            int i = (text = text.substring(0, parameters.getOffset())).lastIndexOf("::");
            if (i != -1) {
                return text.substring(i + 2);
            }
            return text;
        }

        private static String getCurrentToken(@NotNull String text, @NotNull Matcher m, int pos, int groupIndex) {
            return m.start(groupIndex) <= pos && pos <= m.end(groupIndex) ? text.substring(m.start(groupIndex), pos) : null;
        }
    }
}

