/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.toolchains.CidrCompiler;
import com.jetbrains.cidr.toolchains.CidrExecutableTool;
import com.jetbrains.cidr.toolchains.CompilerInfo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends CidrExecutableTool
implements CidrCompiler {
    private static final CompilerRunner DEFAULT_RUNNER;
    @NotNull
    private static volatile CompilerRunner outCompilerRunner;
    private static final int TIMEOUT = 30000;
    private static final String QUERY_PREFIX = "____CIDR_test_query_";
    private static final Pattern QUERY_RESULT_PATTERN;
    private static final Pattern UNSUPPORTED_SWITCH_PATTERN;
    private static final Pattern INVALID_SWITCH_PATTERN;
    private static final Pattern CPP_OPTIONS_PATTERN;
    private static final Pattern[] BAD_SWITCH_FILTER_RULES;
    public static final String CIDR_IGNORE_DEFINITIONS_START = "___CIDR_IGNORE_DEFINITIONS_START";
    public static final String CIDR_IGNORE_DEFINITIONS_END = "___CIDR_IGNORE_DEFINITIONS_END";
    @NotNull
    private final File myWorkingDirectory;

    public static void setGCCErrorInTests(boolean emulate) {
        GCCCompiler.setCompilerRunnerInTests(!emulate ? null : new CompilerRunner(){

            @Override
            @NotNull
            ProcessOutput run(@NotNull GeneralCommandLine cl) throws ExecutionException {
                ProcessOutput output = new ProcessOutput(1);
                output.appendStderr("Emulated GCC error");
                return output;
            }
        });
    }

    public static void setCompilerRunnerInTests(@Nullable CompilerRunner runner) {
        outCompilerRunner = runner == null ? DEFAULT_RUNNER : runner;
    }

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory) {
        super(executable);
        this.myWorkingDirectory = workingDirectory;
    }

    @Override
    @Nullable
    public String readVersion() {
        ProcessOutput output;
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath(this.getExecutablePath());
        cl.addParameter("--version");
        try {
            CapturingProcessHandler processHandler2 = new CapturingProcessHandler(cl);
            output = processHandler2.runProcess(30000);
            if (output.isTimeout()) {
                throw new ExecutionException("process timed out");
            }
        }
        catch (ExecutionException e) {
            CidrLog.LOG.info("Cannot read compiler version: " + cl.getCommandLineString(), (Throwable)e);
            return null;
        }
        List lines = output.getStdoutLines();
        for (String each : lines) {
            if (StringUtil.isEmptyOrSpaces((String)each)) continue;
            return each;
        }
        CidrLog.LOG.info("Cannot read compiler version: " + cl.getCommandLineString() + "\n" + output.getStderr() + "\n" + output.getStdout());
        return null;
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind) {
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return "-xc";
                }
                case OBJ_C: {
                    return "-xobjective-c";
                }
                case CPP: {
                    return "-xc++";
                }
                case OBJ_CPP: {
                    return "-xobjective-c++";
                }
            }
        }
        return "";
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment) throws ExecutionException {
        switches = new CidrSwitchBuilder().addSingle(GCCCompiler.getLanguageOption(languageKind)).addAll(switches).addSingle("-v").addSingle("-dD").addSingle("-E").addSingle("-D___CIDR_IGNORE_DEFINITIONS_START").build();
        ProcessOutput output = this.runGCC(environment, switches, "#define ___CIDR_IGNORE_DEFINITIONS_END\n" + GCCCompiler.buildFeaturesCheckText());
        String stdout = output.getStdout();
        StringBuilder defines = new StringBuilder(stdout.length());
        int size = OCCompilerFeatures.getAllFeatures().size();
        HashMap<String, String> features = new HashMap<String, String>(size);
        HashMap<String, String> extensions = new HashMap<String, String>(size);
        HashMap<String, String> attributes = new HashMap<String, String>(OCCompilerFeatures.getAllAttributes().size());
        GCCCompiler.collectDefinitionsAndFeatures(stdout, defines, features, extensions, attributes);
        String definesString = defines.toString();
        boolean shouldEnableFrameworksWorkaround = SystemInfo.isMac && !definesString.contains("__clang_version__");
        List<HeadersSearchPath> headersSearchPaths = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, environment, this.myWorkingDirectory);
        return new CompilerInfo(definesString, features, extensions, attributes, headersSearchPaths);
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(ProcessOutput output, boolean enableFrameworksWorkaround, CidrToolEnvironment environment, File workingDirectory) {
        ArrayList<HeadersSearchPath> headersSearchPaths = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        Boolean userHeaders = null;
        for (String each : output.getStderrLines()) {
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                userHeaders = true;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                userHeaders = false;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (userHeaders == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            }
            each = StringUtil.nullize((String)each.trim(), (boolean)true);
            if ((each = environment.toLocalPath(workingDirectory, each)) == null) continue;
            File file2 = new File(FileUtil.toCanonicalPath((String)each, (boolean)true));
            headersSearchPaths.add(new HeadersSearchPath(file2, false, userHeaders, isFramework));
            if (!enableFrameworksWorkaround) continue;
            additionalFrameworks.add(new HeadersSearchPath(file2, false, userHeaders, true));
        }
        if (enableFrameworksWorkaround && additionalFrameworks != null) {
            headersSearchPaths.addAll(additionalFrameworks);
        }
        return headersSearchPaths;
    }

    protected static void collectDefinitionsAndFeatures(@NotNull String output, @NotNull StringBuilder defines, @NotNull Map<String, String> features, @NotNull Map<String, String> extensions, @NotNull Map<String, String> attributes) {
        int ignoreStart;
        for (ignoreStart = output.indexOf(CIDR_IGNORE_DEFINITIONS_START); ignoreStart > 0 && !StringUtil.isLineBreak((char)output.charAt(ignoreStart - 1)); --ignoreStart) {
        }
        int ignoreEnd = output.indexOf(CIDR_IGNORE_DEFINITIONS_END);
        if (ignoreEnd > 0) {
            ignoreEnd += CIDR_IGNORE_DEFINITIONS_END.length();
        }
        if (ignoreStart >= 0) {
            OCLog.LOG.assertTrue(ignoreStart < ignoreEnd);
            output = output.substring(0, ignoreStart) + output.substring(ignoreEnd);
        }
        for (String eachLine : StringUtil.splitByLines((String)output)) {
            if ((eachLine = eachLine.trim()).isEmpty()) continue;
            if (eachLine.startsWith("#define ")) {
                defines.append(eachLine).append("\n");
                continue;
            }
            Matcher matcher = QUERY_RESULT_PATTERN.matcher(eachLine);
            if (!matcher.find()) continue;
            String kind = matcher.group(1);
            String feature = matcher.group(2);
            String value = matcher.group(3);
            Map<String, String> container = null;
            if (kind.equals("feature")) {
                container = features;
            }
            if (kind.equals("extension")) {
                container = extensions;
            }
            if (kind.equals("attribute")) {
                container = attributes;
            }
            if (container == null) continue;
            container.put(feature, value);
        }
    }

    protected static String buildFeaturesCheckText() {
        StringBuilder result = new StringBuilder("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n");
        GCCCompiler.addQuery("feature", result, OCCompilerFeatures.getAllFeatures());
        GCCCompiler.addQuery("extension", result, OCCompilerFeatures.getAllFeatures());
        GCCCompiler.addQuery("attribute", result, OCCompilerFeatures.getAllAttributes());
        return result.toString();
    }

    private static void addQuery(String kind, StringBuilder result, Collection<String> items) {
        result.append("#ifdef __has_").append(kind).append("\n");
        for (String each : items) {
            result.append("#if __has_").append(kind).append("(").append(each).append(")\n").append(QUERY_PREFIX).append(kind).append("->").append(each).append("=1\n").append("#else\n").append(QUERY_PREFIX).append(kind).append("->").append(each).append("=0\n").append("#endif\n");
        }
        result.append("#endif\n");
    }

    private ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText) throws ExecutionException {
        HashSet<String> skipOptions = new HashSet<String>();
        skipOptions.add("-Werror");
        skipOptions.add("-fdiagnostics-format");
        skipOptions.add("-include");
        skipOptions.add("-imacros");
        skipOptions.add("-");
        skipOptions.add("-o");
        return this.tryRunGCC(environment, options, skipOptions, 0, 0, fileText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, final @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, @NotNull String fileText) throws ExecutionException {
        ProcessOutput output;
        String gccPath;
        File argumentsFile;
        String fileArgsText;
        block11: {
            Condition<String> argumentsFilter = new Condition<String>(){
                boolean archAdded = false;
                boolean skipOptionValue = false;

                public boolean value(String parameter) {
                    parameter = parameter.trim();
                    boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                    if (this.skipOptionValue) {
                        this.skipOptionValue = false;
                        if (!tokenIsSwitch) {
                            return false;
                        }
                    }
                    if (!skipOptions.contains(parameter)) {
                        if ("-arch".equals(parameter)) {
                            if (this.archAdded) {
                                this.skipOptionValue = true;
                                return false;
                            }
                            this.archAdded = true;
                        }
                        return true;
                    }
                    this.skipOptionValue = tokenIsSwitch;
                    return false;
                }
            };
            List fileArgs = ContainerUtil.filter(options.getFileArgs(), (Condition)argumentsFilter);
            fileArgsText = StringUtil.join((Collection)fileArgs, (String)" ");
            argumentsFile = null;
            File bodyFile = null;
            gccPath = this.getExecutablePath();
            try {
                try {
                    argumentsFile = FileUtil.createTempFile((String)"compiler-arguments", (String)".txt", (boolean)true);
                    FileUtil.writeToFile((File)argumentsFile, (String)fileArgsText);
                    bodyFile = FileUtil.createTempFile((String)"compiler-file", (String)"", (boolean)true);
                    FileUtil.writeToFile((File)bodyFile, (String)fileText);
                }
                catch (IOException e) {
                    throw new ExecutionException("Unable to create temporary file", (Throwable)e);
                }
                GeneralCommandLine cl = new GeneralCommandLine();
                environment.prepare(cl);
                cl.setExePath(gccPath);
                cl.withWorkDirectory(this.myWorkingDirectory);
                cl.getEnvironment().put("LC_ALL", "C");
                cl.addParameters(new String[]{"@" + environment.toEnvPath(argumentsFile.getAbsolutePath())});
                cl.addParameters(new String[]{environment.toEnvPath(bodyFile.getAbsolutePath())});
                CidrLog.LOG.debug("Running compiler: " + cl.getCommandLineString() + "\nArguments file contents: " + fileArgsText);
                output = outCompilerRunner.run(cl);
                if (bodyFile == null) break block11;
            }
            catch (Throwable throwable) {
                if (bodyFile != null) {
                    FileUtil.delete(bodyFile);
                }
                if (argumentsFile != null) {
                    FileUtil.delete((File)argumentsFile);
                }
                throw throwable;
            }
            FileUtil.delete((File)bodyFile);
        }
        if (argumentsFile != null) {
            FileUtil.delete((File)argumentsFile);
        }
        String userFriendlyCommandLine = gccPath + " " + fileArgsText.replaceFirst(Matcher.quoteReplacement(" -D___CIDR_IGNORE_DEFINITIONS_START"), "");
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                CidrLog.LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, fileText);
            }
            throw new ExecutionException("Compiler command timed out: " + userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions)) {
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, fileText);
            }
            String message = "Compiler exited with error code " + output.getExitCode() + ": " + userFriendlyCommandLine + "\n" + output.getStderr();
            throw new ExecutionException(message);
        }
        return output;
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<String> skipOptions) {
        boolean hasNewSkipOptions = false;
        block0: for (String eachError : lines) {
            eachError = eachError.trim();
            for (Pattern rule : BAD_SWITCH_FILTER_RULES) {
                Matcher badOptionOrSwitch = rule.matcher(eachError);
                if (!badOptionOrSwitch.matches()) continue;
                hasNewSkipOptions |= skipOptions.add(badOptionOrSwitch.group(1));
                continue block0;
            }
        }
        return hasNewSkipOptions;
    }

    static {
        outCompilerRunner = DEFAULT_RUNNER = new CompilerRunner();
        QUERY_RESULT_PATTERN = Pattern.compile("^____CIDR_test_query_(feature|extension|attribute)->([^=]+)=(0|1)$");
        UNSUPPORTED_SWITCH_PATTERN = Pattern.compile(".*error:[^\\w-](-+\\S+) is not supported.*");
        INVALID_SWITCH_PATTERN = Pattern.compile(".*error:.*(?:unrecognized|invalid|unsupported).*[^\\w-](-+\\S+)\\W.*");
        CPP_OPTIONS_PATTERN = Pattern.compile(".*error:[^\u2018\u2019'\"]*[\u2018\u2019'\"]([^\u2018\u2019'\"]+)[\u2019'\"].*");
        BAD_SWITCH_FILTER_RULES = new Pattern[]{INVALID_SWITCH_PATTERN, UNSUPPORTED_SWITCH_PATTERN, CPP_OPTIONS_PATTERN};
    }

    static class CompilerRunner {
        CompilerRunner() {
        }

        @NotNull
        ProcessOutput run(@NotNull GeneralCommandLine cl) throws ExecutionException {
            return new CapturingProcessHandler(cl).runProcess(30000);
        }
    }
}

