/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EnvironmentProblems {
    @NotNull
    private final List<String> myProblems = new SmartList();

    public void addProblem(@NotNull String problem) {
        this.myProblems.add(problem);
    }

    public boolean hasProblems() {
        return !this.myProblems.isEmpty();
    }

    @NotNull
    public List<String> getProblems() {
        return Collections.unmodifiableList(this.myProblems);
    }

    public void throwAsExecutionException() throws ExecutionException {
        if (this.hasProblems()) {
            throw new ExecutionException(this.formatProblems());
        }
    }

    @NotNull
    private String formatProblems() {
        return StringUtil.join(this.myProblems, (String)"<br>");
    }
}

