/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.compiler.CidrCompilerResult;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPathTree;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.toolchains.CidrCompiler;
import com.jetbrains.cidr.toolchains.CompilerInfo;
import com.jetbrains.cidr.toolchains.GCCCompiler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerInfoCache {
    private static final ThreadPoolExecutor ourExecutor = CompilerInfoCache.createExecutor(CompilerInfoCache.defaultMaxProcesses(Runtime.getRuntime().availableProcessors()));
    @NotNull
    private final Map<String, CidrCompilerResult<Entry>> myCache = new ConcurrentHashMap<String, CidrCompilerResult<Entry>>();
    @NotNull
    private final Map<String, Future<CidrCompilerResult<Entry>>> myInProcess = new HashMap<String, Future<CidrCompilerResult<Entry>>>();
    @NotNull
    private final Object myLock = new Object();

    static int defaultMaxProcesses(int availableProcessors) {
        return Math.max(1, (int)Math.floor((double)availableProcessors * 0.8));
    }

    @NotNull
    static ThreadPoolExecutor createExecutor(int maxProcesses) {
        ThreadFactory factory = ConcurrencyUtil.newNamedThreadFactory((String)"CompilerInfoCache pooled thread");
        ThreadPoolExecutor executor = new ThreadPoolExecutor(maxProcesses, maxProcesses, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), factory);
        executor.allowCoreThreadTimeOut(true);
        return executor;
    }

    public boolean isEmpty() {
        return this.myCache.isEmpty();
    }

    @NotNull
    public CidrCompilerResult<Entry> getCompilerInfoCache(@NotNull Project project2, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile) {
        File compilerExecutable = compilerSettings.getCompilerExecutable(lang);
        if (compilerExecutable == null) {
            return CidrCompilerResult.create(Entry.EMPTY);
        }
        GCCCompiler compiler = new GCCCompiler(compilerExecutable, compilerSettings.getCompilerWorkingDir());
        return this.getCompilerInfoCache(project2, compiler, compilerSettings, lang, sourceFile, ourExecutor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    CidrCompilerResult<Entry> getCompilerInfoCache(final @NotNull Project project2, final @NotNull CidrCompiler compiler, final @NotNull OCCompilerSettings compilerSettings, final @NotNull OCLanguageKind lang, @Nullable VirtualFile sourceFile, @NotNull ThreadPoolExecutor executor) {
        Future<CidrCompilerResult<Entry>> processing;
        final Pair<String, CidrCompilerSwitches> keyAndSwitches = compilerSettings.getCompilerKeyAndSwitches(lang, sourceFile);
        final String key = (String)keyAndSwitches.first;
        CidrCompilerResult<Entry> cached = this.myCache.get(key);
        if (cached != null) {
            return cached;
        }
        Object object = this.myLock;
        synchronized (object) {
            cached = this.myCache.get(key);
            if (cached != null) {
                return cached;
            }
            processing = this.myInProcess.get(key);
            if (processing == null) {
                processing = executor.submit(new Callable<CidrCompilerResult<Entry>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public CidrCompilerResult<Entry> call() throws Exception {
                        CidrCompilerResult result = CompilerInfoCache.doCollectCompilerInfo(project2, compiler, compilerSettings, lang, (CidrCompilerSwitches)keyAndSwitches.second);
                        Object object = CompilerInfoCache.this.myLock;
                        synchronized (object) {
                            CompilerInfoCache.this.myCache.put(key, result);
                            CompilerInfoCache.this.myInProcess.remove(key);
                        }
                        return result;
                    }
                });
                this.myInProcess.put(key, processing);
            }
        }
        while (true) {
            ProgressManager.checkCanceled();
            try {
                return processing.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException();
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
                continue;
            }
            break;
        }
    }

    @NotNull
    private static CidrCompilerResult<Entry> doCollectCompilerInfo(@NotNull Project project2, @NotNull CidrCompiler compiler, @NotNull OCCompilerSettings compilerSettings, @NotNull OCLanguageKind lang, @NotNull CidrCompilerSwitches switches) {
        try {
            CompilerInfo info = compiler.collectInfo(lang, switches, compilerSettings.getEnvironment());
            HeadersSearchPathTree pathTree = new HeadersSearchPathTree();
            for (HeadersSearchPath each : info.getHeadersSearchPaths()) {
                pathTree.addSearchPathCompacting(each);
            }
            List<HeadersSearchPath> compacted = pathTree.getCompactedPaths();
            ArrayList resultPaths = new ArrayList(compacted.size());
            for (HeadersSearchPath eachPath : compacted) {
                ContainerUtil.addIfNotNull(resultPaths, (Object)((Object)HeadersSearchRoot.createFromHeaderSearchPath(project2, eachPath)));
            }
            return CidrCompilerResult.create(new Entry(info.getDefines(), info.getFeatures(), info.getExtensions(), info.getAttributes(), resultPaths));
        }
        catch (com.intellij.execution.ExecutionException e) {
            return CidrCompilerResult.error(e);
        }
    }

    public static class Entry {
        public static Entry EMPTY = new Entry("", Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList());
        @NotNull
        public final String defines;
        @NotNull
        public final Map<String, String> features;
        @NotNull
        public final Map<String, String> extensions;
        @NotNull
        public final Map<String, String> attributes;
        @NotNull
        public final List<HeadersSearchRoot> headerSearchPaths;

        private Entry(@NotNull String defines, @NotNull Map<String, String> features, @NotNull Map<String, String> extensions, @NotNull Map<String, String> attributes, @NotNull List<HeadersSearchRoot> headerSearchPaths) {
            this.defines = defines;
            this.features = features;
            this.extensions = extensions;
            this.attributes = attributes;
            this.headerSearchPaths = Collections.unmodifiableList(headerSearchPaths);
        }
    }
}

