/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.projectView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.BaseProjectTreeBuilder;
import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ProjectAbstractTreeStructureBase;
import com.intellij.ide.projectView.impl.ProjectTreeStructure;
import com.intellij.ide.projectView.impl.ProjectViewTree;
import com.intellij.ide.projectView.impl.nodes.BasePsiNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewProjectNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.projectView.CidrView;
import gnu.trove.THashSet;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrFilesViewHelper {
    private static final Key<CachedValue<Condition<VirtualFile>>> SCOPE_FILES_KEY = Key.create((String)"SCOPE_FILES_KEY");
    public static final String TITLE = IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    public static final Icon ICON = AllIcons.General.ProjectTab;
    public static final int WEIGHT = 1;
    private static final AlphaComposite COMPOSITE = AlphaComposite.getInstance(3, 0.6f);
    @NotNull
    private final CidrView myView;

    public CidrFilesViewHelper(@NotNull CidrView view) {
        this.myView = view;
    }

    @NotNull
    public CidrView getView() {
        return this.myView;
    }

    @NotNull
    public BaseProjectTreeBuilder setupBuilder(@NotNull BaseProjectTreeBuilder builder) {
        builder.setCanYieldUpdate(false);
        return builder;
    }

    @NotNull
    public ProjectAbstractTreeStructureBase createStructure(@NotNull Project project2, @NotNull String ID2) {
        return new MyProjectTreeStructure(project2, ID2);
    }

    @NotNull
    public ProjectViewTree createTree(final @NotNull Project project2, DefaultTreeModel treeModel) {
        ProjectViewTree tree = new ProjectViewTree(project2, treeModel){

            public String toString() {
                return TITLE + " " + super.toString();
            }

            @Override
            public DefaultMutableTreeNode getSelectedNode() {
                return CidrFilesViewHelper.this.myView.getSelectedNode();
            }
        };
        NodeRenderer renderer = new NodeRenderer(){
            private boolean myInProject;

            @NotNull
            private Condition<VirtualFile> getProjectSourcesScope() {
                return (Condition)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, SCOPE_FILES_KEY, (CachedValueProvider)new CachedValueProvider<Condition<VirtualFile>>(){

                    @Nullable
                    public CachedValueProvider.Result<Condition<VirtualFile>> compute() {
                        THashSet sourceFiles = new THashSet();
                        for (VirtualFile each : OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2)) {
                            while (sourceFiles.add(each) && (each = each.getParent()) != null) {
                            }
                        }
                        Condition<VirtualFile> scopeCondition = new Condition<VirtualFile>((Set)sourceFiles){
                            final /* synthetic */ Set val$sourceFiles;
                            {
                                this.val$sourceFiles = set;
                            }

                            public boolean value(VirtualFile file2) {
                                return this.val$sourceFiles.contains(file2);
                            }
                        };
                        return CachedValueProvider.Result.create((Object)scopeCondition, OCSearchScope.getProjectSourcesCacheDependencies(project2));
                    }
                }, false);
            }

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                this.myInProject = CidrFilesViewHelper.this.isInProjectSources(value, this.getProjectSourcesScope());
                this.mySelected = selected;
            }

            protected void applyAdditionalHints(@NotNull Graphics2D g) {
                super.applyAdditionalHints(g);
                if (!this.myInProject) {
                    g.setComposite(COMPOSITE);
                }
            }

            protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
                Graphics2D g2d = (Graphics2D)g;
                Composite old = null;
                if (!this.myInProject) {
                    old = g2d.getComposite();
                    g2d.setComposite(COMPOSITE);
                }
                super.paintIcon(g, icon, offset);
                if (old != null) {
                    g2d.setComposite(old);
                }
            }
        };
        renderer.setOpaque(false);
        renderer.setIconOpaque(false);
        tree.setCellRenderer((TreeCellRenderer)renderer);
        tree.getEmptyText().setText(CidrBundle.message("project.view.empty", new Object[0]));
        return tree;
    }

    public boolean isInProjectSources(Object value, Condition<VirtualFile> scope) {
        VirtualFile virtualFile;
        DefaultMutableTreeNode node;
        Object userObject;
        if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof BasePsiNode && (virtualFile = ((BasePsiNode)((Object)userObject)).getVirtualFile()) != null) {
            return scope.value((Object)virtualFile);
        }
        return true;
    }

    private static class MyProjectTreeStructure
    extends ProjectTreeStructure
    implements ProjectViewSettings {
        public MyProjectTreeStructure(Project project2, String ID2) {
            super(project2, ID2);
        }

        @Override
        public boolean isShowExcludedFiles() {
            return true;
        }

        @Override
        protected AbstractTreeNode createRoot(Project project2, ViewSettings settings) {
            return new ProjectViewProjectNode(project2, settings){

                @Override
                public boolean contains(@NotNull VirtualFile file2) {
                    return true;
                }
            };
        }
    }
}

